/**
 * 
 */
package org.gcube.accounting.aggregation.strategy;

import org.gcube.accounting.aggregation.AggregatedStorageUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class StorageUsageRecordAggregationStrategy extends AggregationStrategy<AggregatedStorageUsageRecord, StorageUsageRecord>{

	/**
	 * @param serviceUsageRecord
	 */
	public StorageUsageRecordAggregationStrategy(AggregatedStorageUsageRecord storageUsageRecord) {
		super(storageUsageRecord);
		this.aggregationField.add(AggregatedStorageUsageRecord.RESOURCE_OWNER);
		this.aggregationField.add(AggregatedStorageUsageRecord.RESOURCE_SCOPE);
		this.aggregationField.add(AggregatedStorageUsageRecord.RESOURCE_URI);
		this.aggregationField.add(AggregatedStorageUsageRecord.PROVIDER_URI);
		this.aggregationField.add(AggregatedStorageUsageRecord.OPERATION_TYPE);
		this.aggregationField.add(AggregatedStorageUsageRecord.DATA_TYPE);
	}

	protected AggregatedStorageUsageRecord reallyAggregate(AggregatedStorageUsageRecord record)
			throws NotAggregatableRecordsExceptions {
		
		try {
			t.setOperationCount(t.getOperationCount() + record.getOperationCount());
			t.setDataVolume(t.getDataVolume() + record.getDataVolume());
		}catch(Exception e){
			throw new UnsupportedOperationException(e);
		}
		
		return t;
	}

}
