package org.gcube.accounting.datamodel.validations.validators;

import java.io.Serializable;

import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.exception.InvalidValueException;


public class ValidIntegerValidator implements FieldAction {
	
	private static final String ERROR = String.format("Not Instance of %s", Integer.class.getSimpleName());
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
		if(value instanceof Integer){
			return value;
		}
		Integer integerObj = Integer.valueOf((String) value);
		if(integerObj!=null){
			return integerObj;
		}
		
		throw new InvalidValueException(ERROR);
	}

}
