/**
 * 
 */
package org.gcube.accounting.datamodel.deprecationmanagement.validators;

import java.io.Serializable;

import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.UsageRecord.OperationResult;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.validations.validators.ValidOperationResultValidator;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class MoveToOperationResultAction implements FieldAction {
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
		ValidOperationResultValidator vorv = new ValidOperationResultValidator();
		value = vorv.validate(key, value, usageRecord);
		usageRecord.setOperationResult((OperationResult) value);
		return value;
	}
	
}
