/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregation.strategy;

import org.gcube.accounting.aggregation.ServiceUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

public class ServiceUsageRecordAggregationStrategy
extends AggregationStrategy<ServiceUsageRecord, org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord> {
    public ServiceUsageRecordAggregationStrategy(ServiceUsageRecord serviceUsageRecord) {
        super(serviceUsageRecord);
        this.aggregationField.add("callerHost");
        this.aggregationField.add("host");
        this.aggregationField.add("serviceClass");
        this.aggregationField.add("serviceName");
        this.aggregationField.add("calledMethod");
    }

    protected long durationWeightedAverage(ServiceUsageRecord record) {
        long tDuration = ((ServiceUsageRecord)this.t).getDuration() * (long)((ServiceUsageRecord)this.t).getOperationCount();
        long recordDuration = record.getDuration() * (long)record.getOperationCount();
        long totalOperationCount = ((ServiceUsageRecord)this.t).getOperationCount() + record.getOperationCount();
        return (tDuration + recordDuration) / totalOperationCount;
    }

    @Override
    protected ServiceUsageRecord reallyAggregate(ServiceUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            long min;
            ((ServiceUsageRecord)this.t).setDuration(this.durationWeightedAverage(record));
            ((ServiceUsageRecord)this.t).setOperationCount(((ServiceUsageRecord)this.t).getOperationCount() + record.getOperationCount());
            long max = record.getMaxInvocationTime();
            if (max > ((ServiceUsageRecord)this.t).getMaxInvocationTime()) {
                ((ServiceUsageRecord)this.t).setMaxInvocationTime(max);
            }
            if ((min = record.getMinInvocationTime()) < ((ServiceUsageRecord)this.t).getMinInvocationTime()) {
                ((ServiceUsageRecord)this.t).setMinInvocationTime(min);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
        return (ServiceUsageRecord)this.t;
    }
}

