/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

public abstract class AggregationStrategy<T extends AggregatedUsageRecord<T, B>, B extends SingleUsageRecord> {
    protected T t;
    protected Set<String> aggregationField;

    protected void cleanExtraFields() {
        Set<String> neededFields = ((BasicUsageRecord)this.t).requiredFields;
        neededFields.addAll(((BasicUsageRecord)this.t).aggregatedFields);
        HashSet<String> keysToRemove = new HashSet<String>();
        Set<String> propertyKeys = ((BasicUsageRecord)this.t).resourceProperties.keySet();
        for (String propertyName : propertyKeys) {
            if (neededFields.contains(propertyName)) continue;
            keysToRemove.add(propertyName);
        }
        for (String keyToRemove : keysToRemove) {
            ((BasicUsageRecord)this.t).resourceProperties.remove(keyToRemove);
        }
    }

    public AggregationStrategy(T t) {
        this.t = t;
        this.cleanExtraFields();
        this.aggregationField = new HashSet<String>();
        this.aggregationField.add("consumerId");
        this.aggregationField.add("usageRecordType");
        this.aggregationField.add("scope");
        this.aggregationField.add("operationResult");
    }

    public T getAggregatedUsageRecord() {
        return this.t;
    }

    protected String commonFieldHash(B record) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            String concatenation = "";
            for (String field : this.aggregationField) {
                concatenation = concatenation + record.getResourceProperty(field).toString();
            }
            messageDigest.update(concatenation.getBytes());
            return new String(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e.getCause());
        }
    }

    protected boolean isAggregable(UsageRecord record) {
        for (String field : this.aggregationField) {
            Serializable thisValue;
            Serializable recordValue = record.getResourceProperty(field);
            if (recordValue.equals(thisValue = ((BasicUsageRecord)this.t).getResourceProperty(field))) continue;
            return false;
        }
        return true;
    }

    protected abstract T reallyAggregate(T var1) throws NotAggregatableRecordsExceptions;

    public T aggregate(T record) throws NotAggregatableRecordsExceptions {
        try {
            Calendar actualEndTime;
            Calendar convertedEndTime;
            Calendar actualStartTime;
            if (!this.isAggregable((UsageRecord)record)) {
                throw new NotAggregatableRecordsExceptions("The Record provided as argument has different values for field wich must be common to be aggragatable");
            }
            Calendar convertedStartTime = ((BasicUsageRecord)record).getStartTimeAsCalendar();
            if (convertedStartTime.before(actualStartTime = ((BasicUsageRecord)this.t).getStartTimeAsCalendar())) {
                ((BasicUsageRecord)this.t).setStartTime(convertedStartTime);
            }
            if ((convertedEndTime = ((BasicUsageRecord)record).getEndTimeAsCalendar()).after(actualEndTime = ((BasicUsageRecord)this.t).getEndTimeAsCalendar())) {
                ((BasicUsageRecord)this.t).setEndTime(convertedEndTime);
            }
            Calendar newCreationTime = Calendar.getInstance();
            this.t = this.reallyAggregate(record);
            ((BasicUsageRecord)this.t).setCreationTime(newCreationTime);
            return this.t;
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex.getCause());
        }
    }

    public T aggregate(B record) throws NotAggregatableRecordsExceptions {
        try {
            Object convertedRecord = this.t.getAggregatedUsageRecord(record);
            return this.aggregate((B)convertedRecord);
        }
        catch (InvalidValueException e) {
            throw new NotAggregatableRecordsExceptions(e.getCause());
        }
    }
}

