/**
 * 
 */
package org.gcube.accounting.aggregation.strategy;

import org.gcube.accounting.aggregation.StorageUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class StorageUsageRecordAggregationStrategy extends AggregationStrategy<StorageUsageRecord, org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord>{

	/**
	 * @param serviceUsageRecord
	 */
	public StorageUsageRecordAggregationStrategy(StorageUsageRecord storageUsageRecord) {
		super(storageUsageRecord);
		this.aggregationField.add(StorageUsageRecord.RESOURCE_OWNER);
		this.aggregationField.add(StorageUsageRecord.RESOURCE_SCOPE);
		this.aggregationField.add(StorageUsageRecord.RESOURCE_URI);
		this.aggregationField.add(StorageUsageRecord.PROVIDER_URI);
		this.aggregationField.add(StorageUsageRecord.OPERATION_TYPE);
		this.aggregationField.add(StorageUsageRecord.DATA_TYPE);
	}

	protected StorageUsageRecord reallyAggregate(StorageUsageRecord record)
			throws NotAggregatableRecordsExceptions {
		
		try {
			t.setOperationCount(t.getOperationCount() + record.getOperationCount());
			t.setDataVolume(t.getDataVolume() + record.getDataVolume());
		}catch(Exception e){
			throw new UnsupportedOperationException(e.getCause());
		}
		
		return t;
	}

}
