/**
 * 
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * This Class is for library internal use only
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class ServiceUsageRecord extends org.gcube.accounting.datamodel.basetypes.ServiceUsageRecord implements AggregatedUsageRecord<ServiceUsageRecord, org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 6387584974618335623L;
	
	// Redefining DURATION to Set @AggregatedField
	@RequiredField @ValidLong @AggregatedField
	public static final String DURATION = org.gcube.accounting.datamodel.basetypes.ServiceUsageRecord.DURATION;
	
	@RequiredField @ValidLong @AggregatedField
	protected static final String MAX_INVOCATION_TIME = "maxInvocationTime";
	@RequiredField @ValidLong @AggregatedField
	protected static final String MIN_INVOCATION_TIME = "minInvocationTime";
	
	private void init(){
		this.resourceProperties.put(AGGREGATED, true);
	}
	
	public ServiceUsageRecord(){
		super();
		init();
	}
	
	protected ServiceUsageRecord(Map<String, Serializable> properties) throws InvalidValueException{
		super(properties);
		init();
	}
	
	public ServiceUsageRecord(org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord record) throws InvalidValueException{
		super(record.getResourceProperties());
		this.setOperationCount(1);
		long duration = record.getDuration();
		this.setMinInvocationTime(duration);
		this.setMaxInvocationTime(duration);
		Calendar creationTime = record.getCreationTime();
		this.setCreationTime(Calendar.getInstance());
		this.setStartTime(creationTime);
		this.setEndTime(creationTime);
		init();
	}
	
	@Override
	public int getOperationCount() {
		return super.getOperationCount();
	}
	
	@Override
	public void setOperationCount(int operationCount) throws InvalidValueException {
		super.setOperationCount(operationCount);
	}

	public long getMaxInvocationTime() {
		return (Long) this.resourceProperties.get(MAX_INVOCATION_TIME);
	}

	public void setMaxInvocationTime(long maxInvocationTime) throws InvalidValueException {
		setResourceProperty(MAX_INVOCATION_TIME, maxInvocationTime);
	}

	public long getMinInvocationTime() {
		return (Long) this.resourceProperties.get(MIN_INVOCATION_TIME);
	}

	public void setMinInvocationTime(long minInvocationTime) throws InvalidValueException {
		setResourceProperty(MIN_INVOCATION_TIME, minInvocationTime);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public ServiceUsageRecord getAggregatedUsageRecord(
			org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord usageRecord)
			throws InvalidValueException {
		return new ServiceUsageRecord(usageRecord);
	}
	
}
