/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.accounting.aggregation.scheduler.AggregationScheduler;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.accounting.persistence.FallbackPersistence;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountingPersistenceFactory {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceFactory.class);
    public static final String HOME_SYSTEM_PROPERTY = "user.home";
    private static final String ACCOUTING_FALLBACK_FILENAME = "accountingFallback.log";
    private static String fallbackLocation;
    private static Map<String, AccountingPersistence> persistences;

    private static File file(File file) throws IllegalArgumentException {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static synchronized void setFallbackLocation(String path) {
        if (fallbackLocation == null) {
            if (path == null) {
                path = System.getProperty(HOME_SYSTEM_PROPERTY);
            }
            AccountingPersistenceFactory.file(new File(path));
            fallbackLocation = path;
        }
    }

    public static AccountingPersistence getPersistence() {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            logger.error("No Scope available. FallbackPersistence will be used");
            File fallbackFile = new File(fallbackLocation, ACCOUTING_FALLBACK_FILENAME);
            return new FallbackPersistence(fallbackFile);
        }
        AccountingPersistence persistence = persistences.get(scope);
        if (persistence == null) {
            ScopeBean bean = new ScopeBean(scope);
            if (bean.is(ScopeBean.Type.VRE)) {
                bean = bean.enclosingScope();
            }
            String name = bean.name();
            File fallbackFile = new File(fallbackLocation, String.format("%s.%s", name, ACCOUTING_FALLBACK_FILENAME));
            FallbackPersistence fallbackPersistence = new FallbackPersistence(fallbackFile);
            try {
                ServiceLoader<AccountingPersistence> serviceLoader = ServiceLoader.load(AccountingPersistence.class);
                for (AccountingPersistence foundPersistence : serviceLoader) {
                    if (foundPersistence.getClass().isInstance(FallbackPersistence.class)) continue;
                    try {
                        String foundPersistenceClassName = foundPersistence.getClass().getSimpleName();
                        logger.debug("Testing {}", (Object)foundPersistenceClassName);
                        AccountingPersistenceConfiguration configuration = AccountingPersistenceConfiguration.getPersistenceConfiguration(foundPersistenceClassName);
                        foundPersistence.prepareConnection(configuration);
                        persistence = foundPersistence;
                        break;
                    }
                    catch (Exception e) {
                        logger.debug(String.format("%s not initialized correctly. It will not be used", foundPersistence.getClass().getSimpleName()));
                    }
                }
                if (persistence == null) {
                    persistence = fallbackPersistence;
                }
            }
            catch (Exception e) {
                logger.error("Unable to instance a Persistence Implementation. Using fallback as default", e.getCause());
                persistence = fallbackPersistence;
            }
            persistence.setAggregationScheduler(AggregationScheduler.getInstance());
            persistence.setFallback(fallbackPersistence);
            persistences.put(scope, persistence);
        }
        return persistence;
    }

    static {
        persistences = new HashMap<String, AccountingPersistence>();
    }
}

