/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

public class StorageUsageRecord
extends org.gcube.accounting.datamodel.basetypes.StorageUsageRecord
implements AggregatedUsageRecord<StorageUsageRecord, org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord> {
    private static final long serialVersionUID = 1082525518686785682L;
    @RequiredField
    @ValidLong
    @AggregatedField
    public static final String DATA_VOLUME = "dataVolume";

    private void init() {
        this.resourceProperties.put("aggregated", true);
    }

    public StorageUsageRecord() {
        this.init();
    }

    public StorageUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
        this.init();
    }

    public StorageUsageRecord(org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
        this.init();
    }

    @Override
    public int getOperationCount() {
        return super.getOperationCount();
    }

    @Override
    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    @Override
    public StorageUsageRecord getAggregatedUsageRecord(org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord usageRecord) throws InvalidValueException {
        return new StorageUsageRecord(usageRecord);
    }
}

