/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util;

import java.io.PrintStream;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.home.workspace.folder.items.PDF;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.util.IndentedVisitor;

public class WorkspaceTreeVisitor
extends IndentedVisitor {
    public WorkspaceTreeVisitor() {
    }

    public WorkspaceTreeVisitor(String indentationLevel, String indentationChar, PrintStream os) {
        super(indentationLevel, indentationChar, os);
    }

    public void visitVerbose(WorkspaceFolder folder) throws InternalErrorException {
        this.reset();
        this.visitWorkspaceItem(folder);
    }

    protected void visitWorkspaceItem(WorkspaceItem item) throws InternalErrorException {
        this.println();
        switch (item.getType()) {
            case FOLDER: {
                this.visitWorkspaceFolder((WorkspaceFolder)item);
                break;
            }
            case FOLDER_ITEM: {
                this.visitFolderItem((FolderItem)item);
            }
        }
    }

    protected void visitWorkspaceFolder(WorkspaceFolder folder) throws InternalErrorException {
        this.println("/FOLDER/");
        this.printWorkspaceItem(folder);
        this.indent();
        for (WorkspaceItem child : folder.getChildren()) {
            this.visitWorkspaceItem(child);
        }
        this.outdent();
    }

    public void visitFolderItem(FolderItem item) throws InternalErrorException {
        this.println();
        this.println("/ITEM/");
        switch (item.getFolderItemType()) {
            case EXTERNAL_IMAGE: {
                this.visitExternalImage((ExternalImage)item);
                break;
            }
            case EXTERNAL_FILE: {
                this.visitExternalFile((ExternalFile)item);
                break;
            }
            case EXTERNAL_PDF_FILE: {
                this.visitExternalPDFFile((ExternalPDFFile)item);
                break;
            }
            case EXTERNAL_URL: {
                this.visitExternalURL((ExternalUrl)item);
                break;
            }
            case QUERY: {
                this.visitQuery((Query)item);
                break;
            }
            case REPORT: {
                this.visitReport((Report)item);
                break;
            }
            case REPORT_TEMPLATE: {
                this.visitReportTemplate((ReportTemplate)item);
                break;
            }
            default: {
                this.printWorkspaceItem(item);
                this.println("UNSUPPORTED TYPE: " + item.getFolderItemType());
            }
        }
    }

    protected void visitImage(Image img) throws InternalErrorException {
        this.println("MimeType " + img.getMimeType());
        this.println("Width " + img.getWidth());
        this.println("Height " + img.getHeight());
        this.println("Length " + img.getLength());
    }

    protected void visitPDF(PDF pdf) throws InternalErrorException {
        this.println("Number Of Pages " + pdf.getNumberOfPages());
        this.println("Version " + pdf.getVersion());
        this.println("Author " + pdf.getAuthor());
        this.println("Title " + pdf.getTitle());
        this.println("Producer " + pdf.getProducer());
    }

    protected void visitExternalImage(ExternalImage img) throws InternalErrorException {
        this.println("[ExternalImage]");
        this.printFolderItem(img);
        this.visitImage(img);
    }

    protected void visitExternalFile(ExternalFile file) throws InternalErrorException {
        this.println("[ExternalFile]");
        this.printFolderItem(file);
        this.println("MimeType " + file.getMimeType());
        this.println("Length " + file.getLength());
    }

    protected void visitImageH(Image img) throws InternalErrorException {
        this.println("MimeType: " + img.getMimeType() + ", Width: " + img.getWidth() + ", Height: " + img.getHeight() + ", Length: " + img.getLength());
    }

    protected void visitExternalPDFFile(ExternalPDFFile pdf) throws InternalErrorException {
        this.println("[ExternalPDFFile]");
        this.printFolderItem(pdf);
        this.println("MimeType " + pdf.getMimeType());
        this.visitPDF(pdf);
        this.println("Length " + pdf.getLength());
    }

    protected void visitExternalURL(ExternalUrl url) throws InternalErrorException {
        this.println("[ExternalUrl]");
        this.printFolderItem(url);
        this.println("Url " + url.getUrl());
        this.println("Length " + url.getLength());
    }

    protected void visitQuery(Query query) throws InternalErrorException {
        this.println("[Query]");
        this.printFolderItem(query);
        this.println("Query " + query.getQuery());
        this.println("Query type " + (Object)((Object)query.getQueryType()));
        this.println("Length " + query.getLength());
    }

    protected void visitReport(Report report) throws InternalErrorException {
        this.println("[Report]");
        this.printFolderItem(report);
        this.println("Author " + report.getAuthor());
        this.println("LastEditBy " + report.getLastEditBy());
        this.println("TemplateName " + report.getTemplateName());
        this.println("NumberOfSections " + report.getNumberOfSections());
        this.println("Created " + this.sdf.format(report.getCreated().getTime()));
        this.println("LastEdit " + this.sdf.format(report.getLastEdit().getTime()));
        this.println("Status " + report.getStatus());
        this.println("Length " + report.getLength());
    }

    protected void visitReportTemplate(ReportTemplate reportTemplate) throws InternalErrorException {
        this.println("[ReportTemplate]");
        this.printFolderItem(reportTemplate);
        this.println("Author " + reportTemplate.getAuthor());
        this.println("LastEditBy " + reportTemplate.getLastEditBy());
        this.println("NumberOfSections " + reportTemplate.getNumberOfSections());
        this.println("Created " + this.sdf.format(reportTemplate.getCreated().getTime()));
        this.println("LastEdit " + this.sdf.format(reportTemplate.getLastEdit().getTime()));
        this.println("Status " + reportTemplate.getStatus());
        this.println("Length " + reportTemplate.getLength());
    }

    protected void printWorkspaceItem(WorkspaceItem item) throws InternalErrorException {
        this.println("ID: " + item.getId());
        this.println("NAME: " + item.getName());
        this.println("DESCRIPTION: " + item.getDescription());
        this.println("CREATION TIME: " + this.sdf.format(item.getCreationTime().getTime()));
        this.println("OWNER: " + item.getOwner());
    }

    protected void printFolderItem(FolderItem item) throws InternalErrorException {
        this.printWorkspaceItem(item);
    }

    protected void visitUser(User user) throws InternalErrorException {
        this.println("ID: " + user.getId());
        this.println("LOGIN: " + user.getPortalLogin());
    }

    public void visitSimple(WorkspaceItem item) throws InternalErrorException {
        this.reset();
        this.visitItem(item);
    }

    protected void visitItem(WorkspaceItem item) throws InternalErrorException {
        switch (item.getType()) {
            case FOLDER: {
                this.println("/[" + item.getName() + "]");
                break;
            }
            case FOLDER_ITEM: {
                this.println("/" + item.getName());
            }
        }
        this.indent();
        for (WorkspaceItem workspaceItem : item.getChildren()) {
            this.visitItem(workspaceItem);
        }
        this.outdent();
    }
}

