/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper;

import java.util.List;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class DelegateManager {
    private ItemDelegate item;
    private String login;

    public DelegateManager(ItemDelegate item, String login) {
        this.item = item;
        this.login = login;
    }

    public DelegateManager(String name, String type, String parentId) {
        this.item.setName(name);
        this.item.setPrimaryType(type);
        this.item.setParentId(parentId);
    }

    public void save(ItemDelegate itemDelegate) throws RepositoryException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.login, false);
            ItemDelegate delegate = servlets.saveItem(itemDelegate);
            itemDelegate.setId(delegate.getId());
            itemDelegate.setPath(delegate.getPath());
            itemDelegate.setCreationTime(delegate.getCreationTime());
            itemDelegate.setLastModificationTime(delegate.getLastModificationTime());
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
    }

    public ItemDelegate getParent() throws ItemNotFoundException, RepositoryException {
        ItemDelegate parent = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.login, false);
            parent = servlets.getItemById(this.item.getParentId());
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
        return parent;
    }

    public List<ItemDelegate> getNodes() throws ItemNotFoundException, RepositoryException {
        List<ItemDelegate> children = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.login, false);
            children = servlets.getChildrenById(this.item.getId(), false);
        }
        catch (Exception e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
        return children;
    }

    public void remove() throws RepositoryException {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.login, false);
            servlets.removeItem(this.item.getPath());
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
    }

    public ItemDelegate addNode(String name, String type) throws RepositoryException {
        ItemDelegate delegate = new ItemDelegate();
        delegate.setName(name);
        if (type != null) {
            delegate.setPrimaryType(type);
        }
        delegate.setParentId(this.item.getId());
        delegate.setLastAction(WorkspaceItemAction.CREATED);
        return delegate;
    }

    public ItemDelegate addNode(String name) throws RepositoryException {
        ItemDelegate delegate = new ItemDelegate();
        delegate.setName(name);
        delegate.setParentId(this.item.getId());
        return delegate;
    }

    public ItemDelegate getNode(String name) throws ItemNotFoundException, RepositoryException {
        JCRSession servlets = null;
        ItemDelegate delegate = null;
        try {
            servlets = new JCRSession(this.login, false);
            ItemDelegate itemDelegate = delegate = servlets.getItemByPath(this.item.getPath() + "/" + Text.escapeIllegalJcrChars(name));
            return itemDelegate;
        }
        catch (ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
    }
}

