/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

public class PrincipalRestrictionProvider
implements RestrictionProvider,
AccessControlConstants {
    private final RestrictionProvider base;

    public PrincipalRestrictionProvider(RestrictionProvider base) {
        this.base = base;
    }

    @Override
    @Nonnull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
        HashSet<RestrictionDefinition> definitions = new HashSet<RestrictionDefinition>(this.base.getSupportedRestrictions(oakPath));
        definitions.add(new RestrictionDefinitionImpl("rep:nodePath", Type.PATH, true));
        return definitions;
    }

    @Override
    @Nonnull
    public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, @Nonnull Value value) throws RepositoryException {
        if ("rep:nodePath".equals(oakName) && 8 == value.getType()) {
            return new RestrictionImpl(PropertyStates.createProperty(oakName, value), true);
        }
        return this.base.createRestriction(oakPath, oakName, value);
    }

    @Override
    @Nonnull
    public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, Value ... values) throws RepositoryException {
        return this.base.createRestriction(oakPath, oakName, values);
    }

    @Override
    public Set<Restriction> readRestrictions(@Nullable String oakPath, @Nonnull Tree aceTree) {
        HashSet<Restriction> restrictions = new HashSet<Restriction>(this.base.readRestrictions(oakPath, aceTree));
        String value = oakPath == null ? "" : oakPath;
        PropertyState nodePathProp = PropertyStates.createProperty("rep:nodePath", (Object)value, Type.PATH);
        restrictions.add(new RestrictionImpl(nodePathProp, true));
        return restrictions;
    }

    @Override
    public void writeRestrictions(String oakPath, Tree aceTree, Set<Restriction> restrictions) throws RepositoryException {
        Iterator<Restriction> it = Sets.newHashSet(restrictions).iterator();
        while (it.hasNext()) {
            Restriction r = it.next();
            if (!"rep:nodePath".equals(r.getDefinition().getName())) continue;
            it.remove();
        }
        this.base.writeRestrictions(oakPath, aceTree, restrictions);
    }

    @Override
    public void validateRestrictions(String oakPath, @Nonnull Tree aceTree) throws RepositoryException {
        this.base.validateRestrictions(oakPath, aceTree);
    }

    @Override
    @Nonnull
    public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Tree tree) {
        return this.base.getPattern(oakPath, tree);
    }
}

