/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ACFilter
implements EventFilter {
    private final TreePermission treePermission;

    private ACFilter(@Nonnull TreePermission treePermission) {
        this.treePermission = Preconditions.checkNotNull(treePermission);
    }

    public ACFilter(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull PermissionProvider permissionProvider, @Nonnull String basePath) {
        this(ACFilter.getTreePermission(permissionProvider, after.exists() ? after : before, basePath));
    }

    private static TreePermission getTreePermission(PermissionProvider permissionProvider, NodeState root, String basePath) {
        TreePermission treePermission = permissionProvider.getTreePermission(new ImmutableTree(root), TreePermission.EMPTY);
        for (String name : PathUtils.elements(basePath)) {
            root = root.getChildNode(name);
            treePermission = treePermission.getChildPermission(name, root);
        }
        return treePermission;
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return this.treePermission.canRead(after);
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return this.treePermission.canRead(after);
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return this.treePermission.canRead(before);
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return this.treePermission.getChildPermission(name, after).canRead();
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return this.treePermission.getChildPermission(name, before).canRead();
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        return this.treePermission.getChildPermission(name, moved).canRead();
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return this.treePermission.getChildPermission(name, reordered).canRead();
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        return new ACFilter(this.treePermission.getChildPermission(name, after));
    }
}

