/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.observation.DefaultEventHandler;
import org.apache.jackrabbit.oak.plugins.observation.EventHandler;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class FilteredHandler
extends DefaultEventHandler {
    private final EventFilter filter;
    private final EventHandler handler;

    public FilteredHandler(EventFilter filter, EventHandler handler) {
        this.filter = filter;
        this.handler = handler;
    }

    @Override
    public void enter(NodeState before, NodeState after) {
        this.handler.enter(before, after);
    }

    @Override
    public void leave(NodeState before, NodeState after) {
        this.handler.leave(before, after);
    }

    @Override
    @CheckForNull
    public EventHandler getChildHandler(String name, NodeState before, NodeState after) {
        EventHandler h;
        EventFilter f = this.filter.create(name, before, after);
        if (f != null && (h = this.handler.getChildHandler(name, before, after)) != null) {
            return new FilteredHandler(f, h);
        }
        return null;
    }

    @Override
    public void propertyAdded(PropertyState after) {
        if (this.filter.includeAdd(after)) {
            this.handler.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) {
        if (this.filter.includeChange(before, after)) {
            this.handler.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) {
        if (this.filter.includeDelete(before)) {
            this.handler.propertyDeleted(before);
        }
    }

    @Override
    public void nodeAdded(String name, NodeState after) {
        if (this.filter.includeAdd(name, after)) {
            this.handler.nodeAdded(name, after);
        }
    }

    @Override
    public void nodeDeleted(String name, NodeState before) {
        if (this.filter.includeDelete(name, before)) {
            this.handler.nodeDeleted(name, before);
        }
    }

    @Override
    public void nodeMoved(String sourcePath, String name, NodeState moved) {
        if (this.filter.includeMove(sourcePath, name, moved)) {
            this.handler.nodeMoved(sourcePath, name, moved);
        }
    }

    @Override
    public void nodeReordered(String destName, String name, NodeState reordered) {
        if (this.filter.includeReorder(destName, name, reordered)) {
            this.handler.nodeReordered(destName, name, reordered);
        }
    }
}

