/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;

class MemoryDiffCache
implements DiffCache {
    protected final Cache<CacheValue, StringValue> diffCache;
    protected final CacheStats diffCacheStats;

    MemoryDiffCache(DocumentMK.Builder builder) {
        this.diffCache = builder.buildCache(builder.getDiffCacheSize());
        this.diffCacheStats = new CacheStats(this.diffCache, "Document-Diff", builder.getWeigher(), builder.getDiffCacheSize());
    }

    @Override
    @CheckForNull
    public String getChanges(@Nonnull Revision from, @Nonnull Revision to, @Nonnull String path) {
        PathRev key = MemoryDiffCache.diffCacheKey(path, from, to);
        StringValue diff = this.diffCache.getIfPresent(key);
        return diff != null ? diff.toString() : null;
    }

    @Override
    @Nonnull
    public DiffCache.Entry newEntry(@Nonnull Revision from, @Nonnull Revision to) {
        return new MemoryEntry(from, to);
    }

    public CacheStats getDiffCacheStats() {
        return this.diffCacheStats;
    }

    private static PathRev diffCacheKey(@Nonnull String path, @Nonnull Revision from, @Nonnull Revision to) {
        return new PathRev(from + path, to);
    }

    protected class MemoryEntry
    implements DiffCache.Entry {
        private final Revision from;
        private final Revision to;

        protected MemoryEntry(Revision from, Revision to) {
            this.from = Preconditions.checkNotNull(from);
            this.to = Preconditions.checkNotNull(to);
        }

        @Override
        public void append(@Nonnull String path, @Nonnull String changes) {
            PathRev key = MemoryDiffCache.diffCacheKey(path, this.from, this.to);
            MemoryDiffCache.this.diffCache.put(key, new StringValue(changes));
        }

        @Override
        public void done() {
        }
    }
}

