/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.service.ConfigService;
import com.couchbase.client.core.service.DCPService;
import com.couchbase.client.core.service.KeyValueService;
import com.couchbase.client.core.service.OldKeyValueService;
import com.couchbase.client.core.service.OldQueryService;
import com.couchbase.client.core.service.OldSearchService;
import com.couchbase.client.core.service.OldViewService;
import com.couchbase.client.core.service.QueryService;
import com.couchbase.client.core.service.SearchService;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.ViewService;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;

public class ServiceFactory {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ServiceFactory.class);
    private static final boolean FORCE_OLD_SERVICES = Boolean.parseBoolean(System.getProperty("com.couchbase.forceOldServices", "false"));

    private ServiceFactory() {
    }

    public static Service create(String hostname, String bucket, String password, int port, CoreEnvironment env, ServiceType type, RingBuffer<ResponseEvent> responseBuffer) {
        if (FORCE_OLD_SERVICES) {
            switch (type) {
                case BINARY: {
                    return new OldKeyValueService(hostname, bucket, password, port, env, responseBuffer);
                }
                case VIEW: {
                    return new OldViewService(hostname, bucket, password, port, env, responseBuffer);
                }
                case CONFIG: {
                    return new ConfigService(hostname, bucket, password, port, env, responseBuffer);
                }
                case QUERY: {
                    return new OldQueryService(hostname, bucket, password, port, env, responseBuffer);
                }
                case DCP: {
                    return new DCPService(hostname, bucket, password, port, env, responseBuffer);
                }
                case SEARCH: {
                    return new OldSearchService(hostname, bucket, password, port, env, responseBuffer);
                }
            }
            throw new IllegalArgumentException("Unknown Service Type: " + (Object)((Object)type));
        }
        switch (type) {
            case BINARY: {
                return new KeyValueService(hostname, bucket, password, port, env, responseBuffer);
            }
            case VIEW: {
                return new ViewService(hostname, bucket, password, port, env, responseBuffer);
            }
            case CONFIG: {
                return new ConfigService(hostname, bucket, password, port, env, responseBuffer);
            }
            case QUERY: {
                return new QueryService(hostname, bucket, password, port, env, responseBuffer);
            }
            case DCP: {
                return new DCPService(hostname, bucket, password, port, env, responseBuffer);
            }
            case SEARCH: {
                return new SearchService(hostname, bucket, password, port, env, responseBuffer);
            }
        }
        throw new IllegalArgumentException("Unknown Service Type: " + (Object)((Object)type));
    }

    static {
        if (FORCE_OLD_SERVICES) {
            LOGGER.info("Old Service override is enabled!");
        } else {
            LOGGER.debug("New Services are enabled");
        }
    }
}

