/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.lifecycle;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class CompositeWorkspaceInitializer
implements WorkspaceInitializer {
    private final Collection<WorkspaceInitializer> initializers;

    public CompositeWorkspaceInitializer(@Nonnull Collection<WorkspaceInitializer> trackers) {
        this.initializers = trackers;
    }

    public CompositeWorkspaceInitializer(WorkspaceInitializer ... initializers) {
        this.initializers = Arrays.asList(initializers);
    }

    @Override
    public void initialize(NodeBuilder builder, String workspaceName) {
        for (WorkspaceInitializer tracker : this.initializers) {
            tracker.initialize(builder, workspaceName);
        }
    }
}

