/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class FilterImpl
implements Filter {
    private final SelectorImpl selector;
    private final String queryStatement;
    private final QueryEngineSettings settings;
    private boolean alwaysFalse;
    private boolean matchesAllTypes;
    private String path = "/";
    private Filter.PathRestriction pathRestriction = Filter.PathRestriction.NO_RESTRICTION;
    private String pathPlan;
    private final ArrayList<String> fulltextConditions = new ArrayList();
    private FullTextExpression fullTextConstraint;
    private final HashMap<String, Filter.PropertyRestriction> propertyRestrictions = new HashMap();
    private boolean distinct;
    private boolean preparing;

    public FilterImpl() {
        this(null, null, new QueryEngineSettings());
    }

    public FilterImpl(SelectorImpl selector, String queryStatement, QueryEngineSettings settings) {
        this.selector = selector;
        this.queryStatement = queryStatement;
        this.matchesAllTypes = selector != null ? selector.matchesAllTypes() : false;
        this.settings = settings;
    }

    public FilterImpl(Filter filter) {
        FilterImpl impl = (FilterImpl)filter;
        this.alwaysFalse = impl.alwaysFalse;
        this.distinct = impl.distinct;
        this.fullTextConstraint = impl.fullTextConstraint;
        this.matchesAllTypes = impl.matchesAllTypes;
        this.path = impl.path;
        this.pathRestriction = impl.pathRestriction;
        this.propertyRestrictions.putAll(impl.propertyRestrictions);
        this.queryStatement = impl.queryStatement;
        this.selector = impl.selector;
        this.matchesAllTypes = this.selector != null ? this.selector.matchesAllTypes() : false;
        this.settings = filter.getQueryEngineSettings();
    }

    public void setPreparing(boolean preparing) {
        this.preparing = preparing;
    }

    public boolean isPreparing() {
        return this.preparing;
    }

    public boolean isPrepared(SelectorImpl selector) {
        return selector.isPrepared();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Filter.PathRestriction getPathRestriction() {
        return this.pathRestriction;
    }

    @Override
    public String getPathPlan() {
        StringBuilder buff = new StringBuilder();
        String p = this.path;
        if (PathUtils.denotesRoot(this.path)) {
            p = "";
        }
        buff.append(p).append((Object)this.pathRestriction);
        if (this.pathPlan != null) {
            buff.append(" && ").append(this.pathPlan);
        }
        return buff.toString();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setAlwaysFalse() {
        this.propertyRestrictions.clear();
        this.path = "/";
        this.pathRestriction = Filter.PathRestriction.EXACT;
        this.alwaysFalse = true;
    }

    @Override
    public boolean isAlwaysFalse() {
        return this.alwaysFalse;
    }

    public SelectorImpl getSelector() {
        return this.selector;
    }

    @Override
    public boolean matchesAllTypes() {
        return this.matchesAllTypes;
    }

    @Override
    @Nonnull
    public Set<String> getSupertypes() {
        return this.selector == null ? null : this.selector.getSupertypes();
    }

    @Override
    @Nonnull
    public Set<String> getPrimaryTypes() {
        return this.selector == null ? null : this.selector.getPrimaryTypes();
    }

    @Override
    @Nonnull
    public Set<String> getMixinTypes() {
        return this.selector == null ? null : this.selector.getMixinTypes();
    }

    @Override
    public Collection<Filter.PropertyRestriction> getPropertyRestrictions() {
        return this.propertyRestrictions.values();
    }

    @Override
    public Filter.PropertyRestriction getPropertyRestriction(String propertyName) {
        return this.propertyRestrictions.get(propertyName);
    }

    public boolean testPath(String path) {
        if (this.isAlwaysFalse()) {
            return false;
        }
        switch (this.pathRestriction) {
            case NO_RESTRICTION: {
                return true;
            }
            case EXACT: {
                return path.matches(this.path);
            }
            case PARENT: {
                return PathUtils.isAncestor(path, this.path);
            }
            case DIRECT_CHILDREN: {
                return PathUtils.getParentPath(path).equals(this.path);
            }
            case ALL_CHILDREN: {
                return PathUtils.isAncestor(this.path, path);
            }
        }
        throw new IllegalArgumentException("Unknown path restriction: " + (Object)((Object)this.pathRestriction));
    }

    public void restrictPropertyType(String propertyName, Operator operator, int propertyType) {
        if (propertyType == 0) {
            return;
        }
        Filter.PropertyRestriction x = this.addRestricition(propertyName);
        if (x.propertyType != 0 && x.propertyType != propertyType) {
            this.setAlwaysFalse();
        }
        x.propertyType = propertyType;
    }

    public void restrictPropertyAsList(String propertyName, List<PropertyValue> list) {
        Filter.PropertyRestriction x = this.addRestricition(propertyName);
        if (x.list == null) {
            x.list = list;
        } else {
            x.list.retainAll(list);
        }
    }

    public void restrictProperty(String propertyName, Operator op, PropertyValue v) {
        Filter.PropertyRestriction x = this.addRestricition(propertyName);
        PropertyValue oldFirst = x.first;
        PropertyValue oldLast = x.last;
        switch (op) {
            case EQUAL: {
                if (x.first != null && x.last == x.first && x.firstIncluding && x.lastIncluding) break;
                x.first = x.last = v;
                x.lastIncluding = true;
                x.firstIncluding = true;
                break;
            }
            case NOT_EQUAL: {
                if (v == null) break;
                throw new IllegalArgumentException("NOT_EQUAL only supported for NOT_EQUAL NULL");
            }
            case GREATER_THAN: {
                if (x.first != null) break;
                x.first = FilterImpl.maxValue(oldFirst, v);
                x.firstIncluding = false;
                break;
            }
            case GREATER_OR_EQUAL: {
                if (x.first != null) break;
                x.first = FilterImpl.maxValue(oldFirst, v);
                x.firstIncluding = x.first == oldFirst ? x.firstIncluding : true;
                break;
            }
            case LESS_THAN: {
                if (x.last != null) break;
                x.last = FilterImpl.minValue(oldLast, v);
                x.lastIncluding = false;
                break;
            }
            case LESS_OR_EQUAL: {
                if (x.last != null) break;
                x.last = FilterImpl.minValue(oldLast, v);
                x.lastIncluding = x.last == oldLast ? x.lastIncluding : true;
                break;
            }
            case LIKE: {
                if (x.first != null) break;
                x.isLike = true;
                x.first = v;
                break;
            }
        }
        if (x.first != null && x.last != null) {
            if (x.first.compareTo(x.last) > 0) {
                this.setAlwaysFalse();
            } else if (!(x.first.compareTo(x.last) != 0 || x.firstIncluding && x.lastIncluding)) {
                this.setAlwaysFalse();
            }
        }
    }

    private Filter.PropertyRestriction addRestricition(String propertyName) {
        Filter.PropertyRestriction x = this.propertyRestrictions.get(propertyName);
        if (x == null) {
            x = new Filter.PropertyRestriction();
            x.propertyName = propertyName;
            this.propertyRestrictions.put(propertyName, x);
        }
        return x;
    }

    static PropertyValue maxValue(PropertyValue a, PropertyValue b) {
        if (a == null) {
            return b;
        }
        return a.compareTo(b) < 0 ? b : a;
    }

    static PropertyValue minValue(PropertyValue a, PropertyValue b) {
        if (a == null) {
            return b;
        }
        return a.compareTo(b) <= 0 ? a : b;
    }

    public String toString() {
        if (this.alwaysFalse) {
            return "Filter(always false)";
        }
        StringBuilder buff = new StringBuilder();
        buff.append("Filter(");
        if (this.queryStatement != null) {
            buff.append("query=").append(this.queryStatement);
        }
        if (this.fullTextConstraint != null) {
            buff.append("fullText=").append(this.fullTextConstraint);
        }
        buff.append(", path=").append(this.getPathPlan());
        if (!this.propertyRestrictions.isEmpty()) {
            buff.append(", property=[");
            Iterator<Map.Entry<String, Filter.PropertyRestriction>> iterator = this.propertyRestrictions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Filter.PropertyRestriction> p = iterator.next();
                buff.append(p.getKey()).append("=").append(p.getValue());
                if (!iterator.hasNext()) continue;
                buff.append(", ");
            }
            buff.append("]");
        }
        buff.append(")");
        return buff.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restrictPath(String addedPath, Filter.PathRestriction addedPathRestriction) {
        block39: {
            if (addedPath == null) {
                addedPath = "/";
            }
            if (addedPath.startsWith("//")) {
                this.pathPlan = this.pathPlan == null ? "" : this.pathPlan + " && ";
                this.pathPlan = this.pathPlan + addedPath + (Object)((Object)addedPathRestriction);
                return;
            }
            block0 : switch (addedPathRestriction) {
                case NO_RESTRICTION: {
                    return;
                }
                case PARENT: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            break;
                        }
                        case PARENT: {
                            break;
                        }
                        case EXACT: 
                        case DIRECT_CHILDREN: 
                        case ALL_CHILDREN: {
                            if (PathUtils.isAncestor(this.path, addedPath)) break;
                            this.setAlwaysFalse();
                        }
                    }
                    this.pathRestriction = Filter.PathRestriction.PARENT;
                    this.path = addedPath;
                    return;
                }
                case EXACT: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            break;
                        }
                        case PARENT: {
                            if (PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                            break;
                        }
                        case EXACT: {
                            if (addedPath.equals(this.path)) break;
                            this.setAlwaysFalse();
                            break;
                        }
                        case ALL_CHILDREN: {
                            if (PathUtils.isAncestor(this.path, addedPath)) break;
                            this.setAlwaysFalse();
                            break;
                        }
                        case DIRECT_CHILDREN: {
                            if (PathUtils.getParentPath(addedPath).equals(this.path)) break;
                            this.setAlwaysFalse();
                        }
                    }
                    this.path = addedPath;
                    this.pathRestriction = Filter.PathRestriction.EXACT;
                    return;
                }
                case ALL_CHILDREN: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            this.path = addedPath;
                            this.pathRestriction = Filter.PathRestriction.ALL_CHILDREN;
                            return;
                        }
                        case EXACT: 
                        case PARENT: {
                            if (PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                            return;
                        }
                        case ALL_CHILDREN: {
                            if (PathUtils.isAncestor(this.path, addedPath)) {
                                this.path = addedPath;
                                return;
                            }
                            if (this.path.equals(addedPath) || PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                            return;
                        }
                        case DIRECT_CHILDREN: {
                            if (this.path.equals(addedPath) || PathUtils.isAncestor(addedPath, this.path)) break;
                            this.setAlwaysFalse();
                        }
                    }
                    return;
                }
                case DIRECT_CHILDREN: {
                    switch (this.pathRestriction) {
                        case NO_RESTRICTION: {
                            this.path = addedPath;
                            this.pathRestriction = Filter.PathRestriction.DIRECT_CHILDREN;
                            break block0;
                        }
                        case PARENT: {
                            if (PathUtils.isAncestor(addedPath, this.path)) return;
                            this.setAlwaysFalse();
                            break block39;
                        }
                        case EXACT: {
                            if (PathUtils.getParentPath(this.path).equals(addedPath)) return;
                            this.setAlwaysFalse();
                            break block39;
                        }
                        case ALL_CHILDREN: {
                            if (!this.path.equals(addedPath) && !PathUtils.isAncestor(this.path, addedPath)) {
                                this.setAlwaysFalse();
                                break block0;
                            }
                            this.path = addedPath;
                            this.pathRestriction = Filter.PathRestriction.DIRECT_CHILDREN;
                            break block0;
                        }
                        case DIRECT_CHILDREN: {
                            if (this.path.equals(addedPath)) return;
                            this.setAlwaysFalse();
                        }
                    }
                }
            }
        }
    }

    public List<String> getFulltextConditions() {
        return this.fulltextConditions;
    }

    public void restrictFulltextCondition(String condition) {
        this.fulltextConditions.add(condition);
    }

    public void setFullTextConstraint(FullTextExpression constraint) {
        this.fullTextConstraint = constraint;
    }

    @Override
    public FullTextExpression getFullTextConstraint() {
        return this.fullTextConstraint;
    }

    @Override
    public boolean containsNativeConstraint() {
        for (String p : this.propertyRestrictions.keySet()) {
            if (!p.startsWith("native*")) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getQueryStatement() {
        return this.queryStatement;
    }

    public void setMatchesAllTypes(boolean matchesAllTypes) {
        this.matchesAllTypes = matchesAllTypes;
    }

    @Override
    public QueryEngineSettings getQueryEngineSettings() {
        return this.settings;
    }
}

