/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.List;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyValueImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;

public class LengthImpl
extends DynamicOperandImpl {
    private final PropertyValueImpl propertyValue;

    public LengthImpl(PropertyValueImpl propertyValue) {
        this.propertyValue = propertyValue;
    }

    public PropertyValueImpl getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "length(" + this.propertyValue + ')';
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return this.propertyValue.getPropertyExistence();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.propertyValue.getSelectors();
    }

    @Override
    public PropertyValue currentProperty() {
        PropertyValue p = this.propertyValue.currentProperty();
        if (p == null) {
            return null;
        }
        if (!p.isArray()) {
            long length = p.size();
            return PropertyValues.newLong(length);
        }
        throw new IllegalArgumentException("LENGTH(x) on multi-valued property is not supported");
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (v != null) {
            switch (v.getType().tag()) {
                case 3: 
                case 4: 
                case 12: {
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can not compare the length with a constant of type " + PropertyType.nameFromValue(v.getType().tag()) + " and value " + v.toString());
                }
            }
        }
        this.propertyValue.restrict(f, Operator.NOT_EQUAL, null);
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return this.propertyValue.canRestrictSelector(s);
    }

    @Override
    int getPropertyType() {
        return 3;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new LengthImpl(this.propertyValue.createCopy());
    }
}

