/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextParser;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class FullTextSearchImpl
extends ConstraintImpl {
    public static final boolean JACKRABBIT_2_SINGLE_QUOTED_PHRASE = true;
    private final String selectorName;
    private final String relativePath;
    private final String propertyName;
    private final StaticOperandImpl fullTextSearchExpression;
    private SelectorImpl selector;

    public FullTextSearchImpl(String selectorName, String propertyName, StaticOperandImpl fullTextSearchExpression) {
        this.selectorName = selectorName;
        int slash = -1;
        if (propertyName != null) {
            slash = propertyName.lastIndexOf(47);
        }
        if (slash == -1) {
            this.relativePath = null;
        } else {
            this.relativePath = propertyName.substring(0, slash);
            propertyName = propertyName.substring(slash + 1);
        }
        this.propertyName = propertyName == null || "*".equals(propertyName) ? null : propertyName;
        this.fullTextSearchExpression = fullTextSearchExpression;
    }

    public StaticOperandImpl getFullTextSearchExpression() {
        return this.fullTextSearchExpression;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("contains(");
        builder.append(this.quote(this.selectorName));
        builder.append('.');
        String pn = this.propertyName;
        if (pn == null) {
            pn = "*";
        }
        if (this.relativePath != null) {
            pn = this.relativePath + "/" + pn;
        }
        builder.append(this.quote(pn));
        builder.append(", ");
        builder.append(this.getFullTextSearchExpression());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        if (this.propertyName == null) {
            return Collections.emptySet();
        }
        String fullName = this.relativePath != null ? PathUtils.concat(this.relativePath, this.propertyName) : this.propertyName;
        return Collections.singleton(new PropertyExistenceImpl(this.selector, this.selectorName, fullName));
    }

    @Override
    public FullTextExpression getFullTextConstraint(SelectorImpl s) {
        if (!s.equals(this.selector)) {
            return null;
        }
        PropertyValue v = this.fullTextSearchExpression.currentValue();
        try {
            String p = this.propertyName;
            if (this.relativePath != null) {
                if (p == null) {
                    p = "*";
                }
                p = PathUtils.concat(this.relativePath, p);
            }
            String p2 = this.normalizePropertyName(p);
            return FullTextParser.parse(p2, v.getValue(Type.STRING));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid expression: " + this.fullTextSearchExpression, e);
        }
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public Map<DynamicOperandImpl, Set<StaticOperandImpl>> getInMap() {
        return Collections.emptyMap();
    }

    @Override
    public boolean evaluate() {
        if (this.selector.getIndex() instanceof QueryIndex.FulltextQueryIndex) {
            PropertyValue p;
            return this.relativePath != null || this.propertyName == null || (p = this.selector.currentProperty(this.propertyName)) != null;
        }
        StringBuilder buff = new StringBuilder();
        if (this.relativePath == null && this.propertyName != null) {
            PropertyValue p = this.selector.currentProperty(this.propertyName);
            if (p == null) {
                return false;
            }
            FullTextSearchImpl.appendString(buff, p);
        } else {
            Tree tree;
            String path = this.selector.currentPath();
            if (!PathUtils.denotesRoot(path)) {
                FullTextSearchImpl.appendString(buff, PropertyValues.newString(PathUtils.getName(path)));
            }
            if (this.relativePath != null) {
                String rp = this.normalizePath(this.relativePath);
                path = PathUtils.concat(path, rp);
            }
            if ((tree = this.selector.getTree(path)) == null || !tree.exists()) {
                return false;
            }
            if (this.propertyName != null) {
                String pn = this.normalizePropertyName(this.propertyName);
                PropertyState propertyState = tree.getProperty(pn);
                if (propertyState == null) {
                    return false;
                }
                FullTextSearchImpl.appendString(buff, PropertyValues.create(propertyState));
            } else {
                for (PropertyState propertyState : tree.getProperties()) {
                    FullTextSearchImpl.appendString(buff, PropertyValues.create(propertyState));
                }
            }
        }
        return this.getFullTextConstraint(this.selector).evaluate(buff.toString());
    }

    private static void appendString(StringBuilder buff, PropertyValue p) {
        if (p.isArray()) {
            for (String v : p.getValue(Type.STRINGS)) {
                buff.append(v).append(' ');
            }
        } else {
            buff.append(p.getValue(Type.STRING)).append(' ');
        }
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (this.propertyName != null && f.getSelector().equals(this.selector)) {
            String pn = this.normalizePropertyName(this.propertyName);
            f.restrictProperty(pn, Operator.NOT_EQUAL, null);
        }
        f.restrictFulltextCondition(this.fullTextSearchExpression.currentValue().getValue(Type.STRING));
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            this.selector.restrictSelector(this);
        }
    }
}

