/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Preconditions;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.AbstractTypeDefinition;

class ItemDefinitionImpl
extends AbstractTypeDefinition
implements ItemDefinition {
    private final NodeType type;

    protected ItemDefinitionImpl(Tree definition, NodeType type, NamePathMapper mapper) {
        super(definition, mapper);
        this.type = Preconditions.checkNotNull(type);
    }

    @Override
    public NodeType getDeclaringNodeType() {
        return this.type;
    }

    @Override
    public String getName() {
        String oakName = this.getName("jcr:name");
        if (oakName != null) {
            return this.mapper.getJcrName(oakName);
        }
        return "*";
    }

    @Override
    public boolean isAutoCreated() {
        return this.getBoolean("jcr:autoCreated");
    }

    @Override
    public boolean isMandatory() {
        return this.getBoolean("jcr:mandatory");
    }

    @Override
    public int getOnParentVersion() {
        String action = this.getString("jcr:onParentVersion");
        if (action != null) {
            return OnParentVersionAction.valueFromName(action);
        }
        return 1;
    }

    @Override
    public boolean isProtected() {
        return this.getBoolean("jcr:protected");
    }

    public String toString() {
        return this.getName();
    }
}

