/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexLookup;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.OrderedContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class OrderedPropertyIndexLookup
extends PropertyIndexLookup {
    private NodeState root;
    private static final IndexStoreStrategy STORE = new OrderedContentMirrorStoreStrategy();
    private static final IndexStoreStrategy REVERSED_STORE = new OrderedContentMirrorStoreStrategy(OrderedIndex.OrderDirection.DESC);
    private static final double COST_OVERHEAD = 3.0;

    public OrderedPropertyIndexLookup(NodeState root) {
        super(root);
        this.root = root;
    }

    @Override
    IndexStoreStrategy getStrategy(NodeState indexMeta) {
        if (OrderedIndex.OrderDirection.isAscending(indexMeta)) {
            return STORE;
        }
        return REVERSED_STORE;
    }

    public boolean isAscending(NodeState root, String propertyName, Filter filter) {
        NodeState indexMeta = this.getIndexNode(root, propertyName, filter);
        return OrderedIndex.OrderDirection.isAscending(indexMeta);
    }

    @Override
    String getType() {
        return "ordered";
    }

    @Override
    public double getCost(Filter filter, String propertyName, PropertyValue value) {
        double cost = Double.POSITIVE_INFINITY;
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta != null) {
            cost = 3.0 + (double)this.getStrategy(indexMeta).count(indexMeta, PropertyIndex.encode(value), 100);
        }
        return cost;
    }

    public Iterable<String> query(Filter filter, String propertyName, Filter.PropertyRestriction pr) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta == null) {
            throw new IllegalArgumentException("No index for " + propertyName);
        }
        return ((OrderedContentMirrorStoreStrategy)this.getStrategy(indexMeta)).query(filter, propertyName, indexMeta, pr);
    }

    public long getEstimatedEntryCount(String propertyName, PropertyValue value, Filter filter, Filter.PropertyRestriction pr) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        OrderedContentMirrorStoreStrategy strategy = (OrderedContentMirrorStoreStrategy)this.getStrategy(indexMeta);
        return strategy.count(indexMeta, pr, 100);
    }
}

