/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.document.BlobCollector;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;

public class BlobReferenceIterator
implements Iterator<Blob> {
    private static final int BATCH_SIZE = 1000;
    private final DocumentStore docStore;
    private final BlobCollector blobCollector;
    private HashSet<Blob> batch = new HashSet();
    private Iterator<Blob> batchIterator;
    private boolean done;
    private String fromKey = "0000000";

    public BlobReferenceIterator(DocumentNodeStore nodeStore) {
        this.docStore = nodeStore.getDocumentStore();
        this.batchIterator = this.batch.iterator();
        this.blobCollector = new BlobCollector(nodeStore);
    }

    @Override
    public boolean hasNext() {
        if (!this.batchIterator.hasNext()) {
            this.loadBatch();
        }
        return this.batchIterator.hasNext() || !this.done;
    }

    @Override
    public Blob next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.batchIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadBatch() {
        if (this.done) {
            return;
        }
        this.batch.clear();
        do {
            boolean hasMore;
            if (hasMore = this.loadBatchQuery()) continue;
            this.done = true;
            break;
        } while (this.batch.size() <= 1000);
        this.batchIterator = this.batch.iterator();
    }

    private boolean loadBatchQuery() {
        List<NodeDocument> list = this.docStore.query(Collection.NODES, this.fromKey, ";", "_bin", 1L, 1000);
        boolean hasMore = false;
        for (NodeDocument doc : list) {
            if (doc.getId().equals(this.fromKey)) continue;
            hasMore = true;
            this.fromKey = doc.getId();
            this.blobCollector.collect(doc, this.batch);
        }
        return hasMore;
    }
}

