/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataStore;

public class OakFileDataStore
extends FileDataStore {
    private byte[] referenceKey;

    public OakFileDataStore() {
        this.inUse = new NoOpMap();
    }

    public Iterator<DataIdentifier> getAllIdentifiers() {
        return Files.fileTreeTraverser().postOrderTraversal(new File(this.getPath())).filter(new Predicate<File>(){

            @Override
            public boolean apply(File input) {
                return input.isFile();
            }
        }).transform(new Function<File, DataIdentifier>(){

            @Override
            public DataIdentifier apply(File input) {
                return new DataIdentifier(input.getName());
            }
        }).iterator();
    }

    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        if (this.referenceKey != null) {
            return this.referenceKey;
        }
        return super.getOrCreateReferenceKey();
    }

    public void setReferenceKeyEncoded(String encodedKey) {
        this.referenceKey = BaseEncoding.base64().decode(encodedKey);
    }

    public void setReferenceKeyPlainText(String textKey) {
        this.referenceKey = textKey.getBytes(Charsets.UTF_8);
    }

    public void setReferenceKey(byte[] referenceKey) {
        this.referenceKey = referenceKey;
    }

    static class NoOpMap<K, V>
    extends AbstractMap<K, V> {
        NoOpMap() {
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }
    }
}

