/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class VisibleEditor
implements Editor {
    private final Editor editor;

    @CheckForNull
    public static Editor wrap(@CheckForNull Editor editor) {
        if (editor != null) {
            return new VisibleEditor(editor);
        }
        return null;
    }

    public VisibleEditor(Editor editor) {
        this.editor = Preconditions.checkNotNull(editor);
    }

    private boolean isVisible(String name) {
        return name.charAt(0) != ':';
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.editor.enter(before, after);
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.editor.leave(before, after);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (this.isVisible(after.getName())) {
            this.editor.propertyAdded(after);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (this.isVisible(after.getName())) {
            this.editor.propertyChanged(before, after);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (this.isVisible(before.getName())) {
            this.editor.propertyDeleted(before);
        }
    }

    @Override
    @CheckForNull
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (this.isVisible(name)) {
            return VisibleEditor.wrap(this.editor.childNodeAdded(name, after));
        }
        return null;
    }

    @Override
    @CheckForNull
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        if (this.isVisible(name)) {
            return VisibleEditor.wrap(this.editor.childNodeChanged(name, before, after));
        }
        return null;
    }

    @Override
    @CheckForNull
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (this.isVisible(name)) {
            return VisibleEditor.wrap(this.editor.childNodeDeleted(name, before));
        }
        return null;
    }
}

