/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserImporter
implements ProtectedPropertyImporter,
ProtectedNodeImporter,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(UserImporter.class);
    private final int importBehavior;
    private JackrabbitSession session;
    private Root root;
    private NamePathMapper namePathMapper;
    private ReferenceChangeTracker referenceTracker;
    private UserManagerImpl userManager;
    private IdentifierManager identifierManager;
    private boolean initialized = false;
    private Membership currentMembership;
    private Map<String, Membership> memberships = new HashMap<String, Membership>();
    private Map<String, String> currentPw = new HashMap<String, String>(1);
    private Map<String, Principal> principals;

    UserImporter(ConfigurationParameters config) {
        String importBehaviorStr = config.getConfigValue("importBehavior", "ignore");
        this.importBehavior = ImportBehavior.valueFromString(importBehaviorStr);
    }

    @Override
    public boolean init(Session session, Root root, NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, ReferenceChangeTracker referenceTracker, SecurityProvider securityProvider) {
        if (!(session instanceof JackrabbitSession)) {
            log.debug("Importing protected user content requires a JackrabbitSession");
            return false;
        }
        this.session = (JackrabbitSession)session;
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.referenceTracker = referenceTracker;
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (uuidBehavior == 0) {
            log.debug("ImportUUIDBehavior.IMPORT_UUID_CREATE_NEW isn't supported when importing users or groups.");
            return false;
        }
        if (!this.initUserManager(isWorkspaceImport, securityProvider)) {
            return false;
        }
        this.userManager = new UserManagerImpl(root, namePathMapper, securityProvider);
        this.initialized = true;
        return this.initialized;
    }

    private boolean initUserManager(boolean isWorkspaceImport, SecurityProvider securityProvider) {
        try {
            if (!isWorkspaceImport && this.session.getUserManager().isAutoSave()) {
                log.warn("Session import cannot handle user content: UserManager is in autosave mode.");
                return false;
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to initialize UserImporter: ", (Throwable)e);
            return false;
        }
        this.userManager = new UserManagerImpl(this.root, this.namePathMapper, securityProvider);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handlePropInfo(Tree parent, PropInfo propInfo, PropertyDefinition def) throws RepositoryException {
        this.checkInitialized();
        String propName = propInfo.getName();
        Authorizable a = this.userManager.getAuthorizable(parent);
        if (a == null) {
            log.warn("Cannot handle protected PropInfo " + propInfo + ". Node " + parent + " doesn't represent a valid Authorizable.");
            return false;
        }
        if ("rep:authorizableId".equals(propName)) {
            if (!this.isValid(def, "rep:Authorizable", false)) {
                return false;
            }
            String id = propInfo.getTextValue().getString();
            Authorizable existing = this.userManager.getAuthorizable(id);
            if (!a.getPath().equals(existing.getPath())) throw new AuthorizableExistsException(id);
            parent.setProperty("rep:authorizableId", id);
            return false;
        } else {
            if ("rep:principalName".equals(propName)) {
                if (!this.isValid(def, "rep:Authorizable", false)) {
                    return false;
                }
                String principalName = propInfo.getTextValue().getString();
                PrincipalImpl principal = new PrincipalImpl(principalName);
                this.userManager.checkValidPrincipal(principal, a.isGroup());
                this.userManager.setPrincipal(parent, principal);
                if (this.principals == null) {
                    this.principals = new HashMap<String, Principal>();
                }
                this.principals.put(principalName, a.getPrincipal());
                a = this.userManager.getAuthorizable(parent);
                if (a == null) {
                    log.warn("Cannot handle protected PropInfo " + propInfo + ". Node " + parent + " doesn't represent a valid Authorizable.");
                    return false;
                }
                if (parent.getStatus() != Tree.Status.NEW) return true;
                if (a.isGroup()) {
                    this.userManager.onCreate((Group)a);
                    return true;
                } else {
                    if (!this.currentPw.containsKey(a.getID())) return true;
                    this.userManager.onCreate((User)a, this.currentPw.remove(a.getID()));
                }
                return true;
            }
            if ("rep:password".equals(propName)) {
                if (a.isGroup() || !this.isValid(def, "rep:User", false)) {
                    log.warn("Unexpected authorizable or definition for property rep:password");
                    return false;
                }
                String pw = propInfo.getTextValue().getString();
                this.userManager.setPassword(parent, pw, false);
                if (parent.getStatus() != Tree.Status.NEW) return true;
                if (parent.hasProperty("rep:principalName")) {
                    this.userManager.onCreate((User)a, pw);
                    return true;
                } else {
                    this.currentPw.clear();
                    this.currentPw.put(a.getID(), pw);
                }
                return true;
            }
            if ("rep:impersonators".equals(propName)) {
                if (a.isGroup() || !this.isValid(def, "rep:Impersonatable", true)) {
                    log.warn("Unexpected authorizable or definition for property rep:impersonators");
                    return false;
                }
                this.referenceTracker.processedReference(new Impersonators(a.getID(), propInfo.getTextValues()));
                return true;
            }
            if ("rep:disabled".equals(propName)) {
                if (a.isGroup() || !this.isValid(def, "rep:User", false)) {
                    log.warn("Unexpected authorizable or definition for property rep:disabled");
                    return false;
                }
                ((User)a).disable(propInfo.getTextValue().getString());
                return true;
            }
            if (!"rep:members".equals(propName)) return false;
            if (!a.isGroup() || !this.isValid(def, "rep:MemberReferences", true)) {
                return false;
            }
            this.getMembership(a.getID()).addMembers(propInfo.getTextValues());
            return true;
        }
    }

    @Override
    public void processReferences() throws RepositoryException {
        this.checkInitialized();
        for (Membership m : this.memberships.values()) {
            this.referenceTracker.processedReference(m);
        }
        this.memberships.clear();
        ArrayList<Object> processed = new ArrayList<Object>();
        Iterator<Object> it = this.referenceTracker.getProcessedReferences();
        while (it.hasNext()) {
            Object reference = it.next();
            if (reference instanceof Membership) {
                ((Membership)reference).process();
                processed.add(reference);
                continue;
            }
            if (!(reference instanceof Impersonators)) continue;
            ((Impersonators)reference).process();
            processed.add(reference);
        }
        this.referenceTracker.removeReferences(processed);
    }

    @Override
    public boolean start(Tree protectedParent) throws RepositoryException {
        if (UserImporter.isMemberNode(protectedParent)) {
            Tree groupTree = protectedParent;
            while (UserImporter.isMemberNode(groupTree) && !groupTree.isRoot()) {
                groupTree = groupTree.getParent();
            }
            Authorizable auth = this.userManager.getAuthorizable(groupTree);
            if (auth == null) {
                log.debug("Cannot handle protected node " + protectedParent + ". It nor one of its parents represent a valid Authorizable.");
                return false;
            }
            this.currentMembership = this.getMembership(auth.getID());
            return true;
        }
        if (UserImporter.isMemberReferencesListNode(protectedParent)) {
            Authorizable auth = this.userManager.getAuthorizable(protectedParent.getParent());
            if (auth == null) {
                log.debug("Cannot handle protected node " + protectedParent + ". It nor one of its parents represent a valid Authorizable.");
                return false;
            }
            this.currentMembership = this.getMembership(auth.getID());
            return true;
        }
        return false;
    }

    @Override
    public void startChildInfo(NodeInfo childInfo, List<PropInfo> propInfos) throws RepositoryException {
        Preconditions.checkNotNull(this.currentMembership);
        String ntName = childInfo.getPrimaryTypeName();
        if ("rep:Members".equals(ntName)) {
            for (PropInfo prop : propInfos) {
                for (TextValue textValue : prop.getTextValues()) {
                    this.currentMembership.addMember(textValue.getString());
                }
            }
        } else if ("rep:MemberReferences".equals(ntName)) {
            for (PropInfo prop : propInfos) {
                if (!"rep:members".equals(prop.getName())) continue;
                this.currentMembership.addMembers(prop.getTextValues());
            }
        } else {
            log.warn("{} is not of type rep:Members or rep:MemberReferences", (Object)childInfo.getName());
        }
    }

    @Override
    public void endChildInfo() throws RepositoryException {
    }

    @Override
    public void end(Tree protectedParent) throws RepositoryException {
        this.currentMembership = null;
    }

    @Nonnull
    private IdentifierManager getIdentifierManager() {
        if (this.identifierManager == null) {
            this.identifierManager = new IdentifierManager(this.root);
        }
        return this.identifierManager;
    }

    @Nonnull
    private PrincipalManager getPrincipalManager() throws RepositoryException {
        return this.userManager.getPrincipalManager();
    }

    @Nonnull
    private Membership getMembership(@Nonnull String authId) {
        Membership membership = this.memberships.get(authId);
        if (membership == null) {
            membership = new Membership(authId);
            this.memberships.put(authId, membership);
        }
        return membership;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    private boolean isValid(PropertyDefinition definition, String oakNodeTypeName, boolean multipleStatus) {
        return multipleStatus == definition.isMultiple() && definition.getDeclaringNodeType().isNodeType(this.namePathMapper.getJcrName(oakNodeTypeName));
    }

    private static boolean isMemberNode(@Nullable Tree tree) {
        return tree != null && "rep:Members".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    private static boolean isMemberReferencesListNode(@Nullable Tree tree) {
        return tree != null && "rep:MemberReferencesList".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    private void handleFailure(String msg) throws ConstraintViolationException {
        switch (this.importBehavior) {
            case 1: 
            case 2: {
                log.warn(msg);
                break;
            }
            case 3: {
                throw new ConstraintViolationException(msg);
            }
        }
    }

    private final class Impersonators {
        private final String userId;
        private final Set<String> principalNames = new HashSet<String>();

        private Impersonators(String userId, List<? extends TextValue> values) {
            this.userId = userId;
            for (TextValue textValue : values) {
                this.principalNames.add(textValue.getString());
            }
        }

        private void process() throws RepositoryException {
            Authorizable a = UserImporter.this.userManager.getAuthorizable(this.userId);
            if (a == null || a.isGroup()) {
                throw new RepositoryException(this.userId + " does not represent a valid user.");
            }
            Impersonation imp = Preconditions.checkNotNull(((User)a).getImpersonation());
            HashMap<String, Principal> toRemove = new HashMap<String, Principal>();
            PrincipalIterator pit = imp.getImpersonators();
            while (pit.hasNext()) {
                Principal p = pit.nextPrincipal();
                toRemove.put(p.getName(), p);
            }
            ArrayList<String> toAdd = new ArrayList<String>();
            for (String principalName : this.principalNames) {
                if (toRemove.remove(principalName) != null) continue;
                toAdd.add(principalName);
            }
            for (Principal p : toRemove.values()) {
                if (imp.revokeImpersonation(p)) continue;
                String principalName = p.getName();
                UserImporter.this.handleFailure("Failed to revoke impersonation for " + principalName + " on " + a);
            }
            ArrayList<String> nonExisting = new ArrayList<String>();
            for (String principalName : toAdd) {
                Principal principal = UserImporter.this.principals.containsKey(principalName) ? (Principal)UserImporter.this.principals.get(principalName) : new PrincipalImpl(principalName);
                if (imp.grantImpersonation(principal)) continue;
                UserImporter.this.handleFailure("Failed to grant impersonation for " + principalName + " on " + a);
                if (UserImporter.this.importBehavior != 2 || UserImporter.this.getPrincipalManager().getPrincipal(principalName) != null) continue;
                log.info("ImportBehavior.BESTEFFORT: Remember non-existing impersonator for special processing.");
                nonExisting.add(principalName);
            }
            if (!nonExisting.isEmpty()) {
                Tree userTree = Preconditions.checkNotNull(UserImporter.this.root.getTree(a.getPath()));
                PropertyState impersonators = userTree.getProperty("rep:impersonators");
                if (impersonators != null) {
                    for (String existing : impersonators.getValue(Type.STRINGS)) {
                        nonExisting.add(existing);
                    }
                }
                userTree.setProperty("rep:impersonators", nonExisting, Type.STRINGS);
            }
        }
    }

    private final class Membership {
        private final String groupId;
        private final Set<String> members = new TreeSet<String>();

        Membership(String groupId) {
            this.groupId = groupId;
        }

        void addMember(String id) {
            this.members.add(id);
        }

        void addMembers(List<? extends TextValue> tvs) {
            for (TextValue textValue : tvs) {
                this.addMember(textValue.getString());
            }
        }

        void process() throws RepositoryException {
            Authorizable a = UserImporter.this.userManager.getAuthorizable(this.groupId);
            if (a == null || !a.isGroup()) {
                throw new RepositoryException(this.groupId + " does not represent a valid group.");
            }
            Group gr = (Group)a;
            HashMap<String, Authorizable> toRemove = new HashMap<String, Authorizable>();
            Iterator<Authorizable> declMembers = gr.getDeclaredMembers();
            while (declMembers.hasNext()) {
                Authorizable dm = declMembers.next();
                toRemove.put(dm.getID(), dm);
            }
            ArrayList<Authorizable> toAdd = new ArrayList<Authorizable>();
            HashSet<String> nonExisting = new HashSet<String>();
            for (String contentId : this.members) {
                String remapped = UserImporter.this.referenceTracker.get(contentId);
                String memberContentId = remapped == null ? contentId : remapped;
                Authorizable member = null;
                try {
                    Tree n = UserImporter.this.getIdentifierManager().getTree(memberContentId);
                    member = UserImporter.this.userManager.getAuthorizable(n);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                if (member != null) {
                    if (toRemove.remove(member.getID()) != null) continue;
                    toAdd.add(member);
                    continue;
                }
                UserImporter.this.handleFailure("New member of " + gr + ": No such authorizable (NodeID = " + memberContentId + ')');
                if (UserImporter.this.importBehavior != 2) continue;
                log.info("ImportBehavior.BESTEFFORT: Remember non-existing member for processing.");
                nonExisting.add(contentId);
            }
            for (Authorizable m : toRemove.values()) {
                if (gr.removeMember(m)) continue;
                UserImporter.this.handleFailure("Failed remove existing member (" + m + ") from " + gr);
            }
            for (Authorizable m : toAdd) {
                if (gr.addMember(m)) continue;
                UserImporter.this.handleFailure("Failed add member (" + m + ") to " + gr);
            }
            if (!nonExisting.isEmpty()) {
                log.info("ImportBehavior.BESTEFFORT: Found " + nonExisting.size() + " entries of rep:members pointing to non-existing authorizables. Adding to rep:members.");
                Tree groupTree = UserImporter.this.root.getTree(gr.getPath());
                MembershipProvider membershipProvider = UserImporter.this.userManager.getMembershipProvider();
                for (String member : nonExisting) {
                    membershipProvider.addMember(groupTree, member);
                }
            }
        }
    }
}

