/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.CachedNodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.CollisionHandler;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.PropertyHistory;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.ValueMap;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDocument
extends Document
implements CachedNodeDocument {
    public static final NodeDocument NULL = new NodeDocument(new MemoryDocumentStore());
    static final Logger LOG;
    public static final String MIN_ID_VALUE = "0000000";
    public static final String MAX_ID_VALUE = ";";
    static final int SPLIT_CANDIDATE_THRESHOLD = 8192;
    static final int DOC_SIZE_THRESHOLD = 262144;
    static final int NUM_REVS_THRESHOLD = 100;
    static final float SPLIT_RATIO = 0.3f;
    static final int PREV_SPLIT_FACTOR = 10;
    static final String COLLISIONS = "_collisions";
    public static final String MODIFIED_IN_SECS = "_modified";
    private static final NavigableMap<Revision, Range> EMPTY_RANGE_MAP;
    private static final String COMMIT_ROOT = "_commitRoot";
    private static final String PREVIOUS = "_prev";
    private static final String DELETED = "_deleted";
    public static final String DELETED_ONCE = "_deletedOnce";
    private static final String REVISIONS = "_revisions";
    private static final String LAST_REV = "_lastRev";
    private static final String CHILDREN_FLAG = "_children";
    public static final String PATH = "_path";
    public static final String HAS_BINARY_FLAG = "_bin";
    public static final String SD_TYPE = "_sdType";
    public static final String SD_MAX_REV_TIME_IN_SECS = "_sdMaxRevTime";
    private static final Set<String> IGNORE_ON_SPLIT;
    public static final long HAS_BINARY_VAL = 1L;
    final DocumentStore store;
    private NavigableMap<Revision, Range> previous;
    private final AtomicLong lastCheckTime = new AtomicLong(System.currentTimeMillis());
    private final long creationTime;

    NodeDocument(@Nonnull DocumentStore store) {
        this(store, System.currentTimeMillis());
    }

    public NodeDocument(@Nonnull DocumentStore store, long creationTime) {
        this.store = Preconditions.checkNotNull(store);
        this.creationTime = creationTime;
    }

    @Nonnull
    public Map<Revision, String> getValueMap(@Nonnull String key) {
        if (IGNORE_ON_SPLIT.contains(key)) {
            return Collections.emptyMap();
        }
        return ValueMap.create(this, key);
    }

    @Override
    public long getCreated() {
        return this.creationTime;
    }

    public boolean hasChildren() {
        Boolean childrenFlag = (Boolean)this.get(CHILDREN_FLAG);
        return childrenFlag != null && childrenFlag != false;
    }

    public boolean wasDeletedOnce() {
        Boolean deletedOnceFlag = (Boolean)this.get(DELETED_ONCE);
        return deletedOnceFlag != null && deletedOnceFlag != false;
    }

    public boolean hasBeenModifiedSince(long lastModifiedTime) {
        Long modified = (Long)this.get(MODIFIED_IN_SECS);
        return modified != null && modified > TimeUnit.MILLISECONDS.toSeconds(lastModifiedTime);
    }

    public boolean hasAllRevisionLessThan(long maxRevisionTime) {
        Long maxRevTimeStamp = (Long)this.get(SD_MAX_REV_TIME_IN_SECS);
        return maxRevTimeStamp != null && maxRevTimeStamp < TimeUnit.MILLISECONDS.toSeconds(maxRevisionTime);
    }

    public boolean isSplitDocument() {
        return this.getSplitDocType() != SplitDocType.NONE;
    }

    public SplitDocType getSplitDocType() {
        return SplitDocType.valueOf((Integer)this.get(SD_TYPE));
    }

    @Override
    public void markUpToDate(long checkTime) {
        this.lastCheckTime.set(checkTime);
    }

    @Override
    public boolean isUpToDate(long lastCheckTime) {
        return lastCheckTime <= this.lastCheckTime.get();
    }

    @Override
    public long getLastCheckTime() {
        return this.lastCheckTime.get();
    }

    public boolean hasBinary() {
        Number flag = (Number)this.get(HAS_BINARY_FLAG);
        if (flag == null) {
            return false;
        }
        return (long)flag.intValue() == 1L;
    }

    @Nonnull
    public String getMainPath() {
        String p = this.getPath();
        if (p.startsWith("p")) {
            if ((p = PathUtils.getAncestorPath(p, 2)).length() == 1) {
                return "/";
            }
            return p.substring(1);
        }
        return p;
    }

    @Nonnull
    public Map<Integer, Revision> getLastRev() {
        HashMap<Integer, Revision> map = Maps.newHashMap();
        SortedMap<Revision, String> valueMap = this.getLocalMap(LAST_REV);
        for (Map.Entry e : valueMap.entrySet()) {
            int clusterId = ((Revision)e.getKey()).getClusterId();
            Revision rev = Revision.fromString((String)e.getValue());
            map.put(clusterId, rev);
        }
        return map;
    }

    public boolean isCommitted(@Nonnull Revision revision) {
        NodeDocument commitRootDoc = this.getCommitRoot(Preconditions.checkNotNull(revision));
        if (commitRootDoc == null) {
            return false;
        }
        String value = (String)commitRootDoc.getLocalRevisions().get(revision);
        if (value != null) {
            return Utils.isCommitted(value);
        }
        for (NodeDocument prev : commitRootDoc.getPreviousDocs(REVISIONS, revision)) {
            if (!prev.containsRevision(revision)) continue;
            return prev.isCommitted(revision);
        }
        return false;
    }

    public boolean containsRevision(@Nonnull Revision revision) {
        if (this.getLocalRevisions().containsKey(revision)) {
            return true;
        }
        for (NodeDocument prev : this.getPreviousDocs(REVISIONS, revision)) {
            if (!prev.containsRevision(revision)) continue;
            return true;
        }
        return false;
    }

    public SortedMap<Revision, Revision> getUncommittedRevisions(RevisionContext context) {
        SortedMap<Revision, String> valueMap = this.getLocalRevisions();
        TreeMap<Revision, Revision> revisions = new TreeMap<Revision, Revision>(context.getRevisionComparator());
        for (Map.Entry commit : valueMap.entrySet()) {
            Revision r;
            if (Utils.isCommitted((String)commit.getValue()) || (r = (Revision)commit.getKey()).getClusterId() != context.getClusterId()) continue;
            Revision b = Revision.fromString((String)commit.getValue());
            revisions.put(r, b);
        }
        return revisions;
    }

    @CheckForNull
    public String getCommitRootPath(Revision revision) {
        String depth = this.getCommitRootDepth(revision);
        if (depth != null) {
            if (depth.equals("0")) {
                return "/";
            }
            String p = this.getPath();
            return PathUtils.getAncestorPath(p, PathUtils.getDepth(p) - Integer.parseInt(depth));
        }
        return null;
    }

    @CheckForNull
    public Revision getNewestRevision(final RevisionContext context, final Revision changeRev, final CollisionHandler handler) {
        final HashMap validRevisions = Maps.newHashMap();
        Predicate<Revision> predicate = new Predicate<Revision>(){

            @Override
            public boolean apply(Revision input) {
                if (input.equals(changeRev)) {
                    return false;
                }
                if (NodeDocument.this.isValidRevision(context, input, null, changeRev, validRevisions)) {
                    return true;
                }
                handler.concurrentModification(input);
                return false;
            }
        };
        Revision newestRev = null;
        SortedMap<Revision, String> revisions = this.getLocalRevisions();
        SortedMap<Revision, String> commitRoots = this.getLocalCommitRoot();
        Iterator<Revision> it = Iterables.filter(Iterables.mergeSorted(Arrays.asList(revisions.keySet(), commitRoots.keySet()), revisions.comparator()), predicate).iterator();
        if (it.hasNext()) {
            newestRev = it.next();
        } else {
            it = Iterables.filter(Iterables.mergeSorted(Arrays.asList(this.getValueMap(REVISIONS).keySet(), this.getValueMap(COMMIT_ROOT).keySet()), revisions.comparator()), predicate).iterator();
            if (it.hasNext()) {
                newestRev = it.next();
            }
        }
        if (newestRev == null) {
            return null;
        }
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        String value = (String)deleted.get(newestRev);
        if (value == null && deleted.headMap(newestRev).isEmpty()) {
            return newestRev;
        }
        if (value == null) {
            value = this.getDeleted().get(newestRev);
        }
        if ("true".equals(value)) {
            return null;
        }
        return newestRev;
    }

    boolean isValidRevision(@Nonnull RevisionContext context, @Nonnull Revision rev, @Nullable String commitValue, @Nonnull Revision readRevision, @Nonnull Map<Revision, String> validRevisions) {
        if (validRevisions.containsKey(rev)) {
            return true;
        }
        NodeDocument doc = this.getCommitRoot(rev);
        if (doc == null) {
            return false;
        }
        if (doc.isCommitted(context, rev, commitValue, readRevision)) {
            validRevisions.put(rev, commitValue);
            return true;
        }
        return false;
    }

    @CheckForNull
    public DocumentNodeState getNodeAtRevision(@Nonnull DocumentNodeStore nodeStore, @Nonnull Revision readRevision, @Nullable Revision lastModified) {
        Revision r;
        HashMap<Revision, String> validRevisions = Maps.newHashMap();
        Revision min = this.getLiveRevision(nodeStore, readRevision, validRevisions);
        if (min == null) {
            return null;
        }
        String path = this.getPath();
        DocumentNodeState n = new DocumentNodeState(nodeStore, path, readRevision, this.hasChildren());
        Revision lastRevision = min;
        for (String key : this.keySet()) {
            if (!Utils.isPropertyName(key)) continue;
            Value value = this.getLatestValue(nodeStore, this.getLocalMap(key), min, readRevision, validRevisions);
            if (value == null && !this.getPreviousRanges().isEmpty()) {
                value = this.getLatestValue(nodeStore, this.getValueMap(key), min, readRevision, validRevisions);
            }
            String propertyName = Utils.unescapePropertyName(key);
            String v = value != null ? value.value : null;
            n.setProperty(propertyName, v);
            if (value == null || !NodeDocument.isRevisionNewer(nodeStore, value.revision, lastRevision)) continue;
            lastRevision = value.revision;
        }
        Branch branch = nodeStore.getBranches().getBranch(readRevision);
        HashMap<Integer, Revision> lastRevs = Maps.newHashMap(this.getLastRev());
        if (lastModified != null) {
            lastRevs.put(nodeStore.getClusterId(), lastModified);
        }
        Revision branchBase = null;
        if (branch != null) {
            branchBase = branch.getBase(readRevision);
        }
        for (Revision r2 : lastRevs.values()) {
            if (NodeDocument.isRevisionNewer(nodeStore, r2, readRevision)) {
                lastRevision = readRevision;
                continue;
            }
            if (branchBase != null && NodeDocument.isRevisionNewer(nodeStore, r2, branchBase)) {
                r2 = branchBase;
            }
            if (!NodeDocument.isRevisionNewer(nodeStore, r2, lastRevision)) continue;
            lastRevision = r2;
        }
        if (branch != null && (r = branch.getUnsavedLastRevision(path, readRevision)) != null) {
            lastRevision = r.asBranchRevision();
        }
        n.setLastRevision(lastRevision);
        return n;
    }

    @CheckForNull
    public Revision getLiveRevision(RevisionContext context, Revision maxRev, Map<Revision, String> validRevisions) {
        Value value = this.getLatestValue(context, this.getLocalDeleted(), null, maxRev, validRevisions);
        if (value == null && !this.getPreviousRanges().isEmpty()) {
            value = this.getLatestValue(context, this.getDeleted(), null, maxRev, validRevisions);
        }
        return value != null && value.value.equals("false") ? value.revision : null;
    }

    boolean isConflicting(@Nonnull UpdateOp op, @Nonnull Revision baseRevision, @Nonnull Revision commitRevision, @Nonnull RevisionContext context) {
        SortedMap<Revision, String> deleted = this.getLocalDeleted();
        for (Map.Entry entry : deleted.entrySet()) {
            if (((Revision)entry.getKey()).equals(commitRevision) || !NodeDocument.isRevisionNewer(context, (Revision)entry.getKey(), baseRevision)) continue;
            return true;
        }
        for (Map.Entry<Object, Object> entry : op.getChanges().entrySet()) {
            if (((UpdateOp.Operation)entry.getValue()).type != UpdateOp.Operation.Type.SET_MAP_ENTRY) continue;
            String name = ((UpdateOp.Key)entry.getKey()).getName();
            if (DELETED.equals(name)) {
                return true;
            }
            if (!Utils.isPropertyName(name)) continue;
            for (Revision rev : this.getValueMap(name).keySet()) {
                if (rev.equals(commitRevision) || !NodeDocument.isRevisionNewer(context, rev, baseRevision)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public Iterable<UpdateOp> split(@Nonnull RevisionContext context) {
        NavigableMap<Revision, Range> previous = this.getPreviousRanges();
        if (this.getLocalRevisions().size() + this.getLocalCommitRoot().size() <= 100 && this.getMemory() < 262144 && previous.size() < 10) {
            return Collections.emptyList();
        }
        String path = this.getPath();
        String id = this.getId();
        if (id == null) {
            throw new IllegalStateException("document does not have an id: " + this);
        }
        HashMap prevHisto = Maps.newHashMap();
        for (Map.Entry entry : previous.entrySet()) {
            Revision rev = (Revision)entry.getKey();
            if (rev.getClusterId() != context.getClusterId()) continue;
            Range r = (Range)entry.getValue();
            ArrayList<Range> list = (ArrayList<Range>)prevHisto.get(r.getHeight());
            if (list == null) {
                list = new ArrayList<Range>();
                prevHisto.put(r.getHeight(), list);
            }
            list.add(r);
        }
        HashMap splitValues = new HashMap();
        for (String property : this.data.keySet()) {
            if (IGNORE_ON_SPLIT.contains(property)) continue;
            TreeMap splitMap = new TreeMap(context.getRevisionComparator());
            splitValues.put(property, splitMap);
            SortedMap<Revision, String> valueMap = this.getLocalMap(property);
            for (Map.Entry entry : valueMap.entrySet()) {
                Revision rev = (Revision)entry.getKey();
                if (rev.getClusterId() != context.getClusterId() || !this.isCommitted(rev)) continue;
                splitMap.put(rev, entry.getValue());
            }
        }
        ArrayList<UpdateOp> splitOps = Lists.newArrayList();
        int numValues = 0;
        Revision high = null;
        Revision low = null;
        for (NavigableMap navigableMap : splitValues.values()) {
            if (!navigableMap.isEmpty()) {
                navigableMap.remove(navigableMap.lastKey());
            }
            if (navigableMap.isEmpty()) continue;
            if (high == null || NodeDocument.isRevisionNewer(context, (Revision)navigableMap.lastKey(), high)) {
                high = (Revision)navigableMap.lastKey();
            }
            if (low == null || NodeDocument.isRevisionNewer(context, low, (Revision)navigableMap.firstKey())) {
                low = (Revision)navigableMap.firstKey();
            }
            numValues += navigableMap.size();
        }
        UpdateOp main = null;
        if (high != null && low != null && (numValues >= 100 || this.getMemory() > 262144)) {
            main = new UpdateOp(id, false);
            NodeDocument.setPrevious(main, new Range(high, low, 0));
            String string = Utils.getPreviousPathFor(path, high, 0);
            UpdateOp old = new UpdateOp(Utils.getIdFromPath(string), true);
            old.set("_id", old.getId());
            if (Utils.isLongPath(string)) {
                old.set(PATH, string);
            }
            for (String property : splitValues.keySet()) {
                NavigableMap splitMap = (NavigableMap)splitValues.get(property);
                for (Map.Entry entry : splitMap.entrySet()) {
                    Revision r = (Revision)entry.getKey();
                    main.removeMapEntry(property, r);
                    old.setMapEntry(property, r, entry.getValue());
                }
            }
            NodeDocument oldDoc = new NodeDocument(this.store);
            UpdateUtils.applyChanges(oldDoc, old, context.getRevisionComparator());
            NodeDocument.setSplitDocProps(this, oldDoc, old, high);
            if ((float)oldDoc.getMemory() > (float)this.getMemory() * 0.3f || numValues >= 100) {
                splitOps.add(old);
            } else {
                main = null;
            }
        }
        for (Map.Entry entry : prevHisto.entrySet()) {
            if (((List)entry.getValue()).size() < 10) continue;
            if (main == null) {
                main = new UpdateOp(id, false);
            }
            Revision h = null;
            Revision l = null;
            for (Range r : (List)entry.getValue()) {
                if (h == null || NodeDocument.isRevisionNewer(context, r.high, h)) {
                    h = r.high;
                }
                if (l == null || NodeDocument.isRevisionNewer(context, l, r.low)) {
                    l = r.low;
                }
                NodeDocument.removePrevious(main, r);
            }
            if (h == null || l == null) {
                throw new IllegalStateException();
            }
            String prevPath = Utils.getPreviousPathFor(path, h, (Integer)entry.getKey() + 1);
            String prevId = Utils.getIdFromPath(prevPath);
            UpdateOp intermediate = new UpdateOp(prevId, true);
            intermediate.set("_id", prevId);
            if (Utils.isLongPath(prevPath)) {
                intermediate.set(PATH, prevPath);
            }
            NodeDocument.setPrevious(main, new Range(h, l, (Integer)entry.getKey() + 1));
            for (Range r : (List)entry.getValue()) {
                NodeDocument.setPrevious(intermediate, r);
            }
            NodeDocument.setIntermediateDocProps(intermediate, h);
            splitOps.add(intermediate);
        }
        if (main != null && !splitOps.isEmpty()) {
            splitOps.add(main);
        }
        return splitOps;
    }

    @Nonnull
    NavigableMap<Revision, Range> getPreviousRanges() {
        if (this.previous == null) {
            SortedMap<Revision, String> map = this.getLocalMap(PREVIOUS);
            if (map.isEmpty()) {
                this.previous = EMPTY_RANGE_MAP;
            } else {
                TreeMap<Revision, Range> transformed = new TreeMap<Revision, Range>(StableRevisionComparator.REVERSE);
                for (Map.Entry entry : map.entrySet()) {
                    Range r = Range.fromEntry((Revision)entry.getKey(), (String)entry.getValue());
                    transformed.put(r.high, r);
                }
                this.previous = Maps.unmodifiableNavigableMap(transformed);
            }
        }
        return this.previous;
    }

    @Nonnull
    Iterable<NodeDocument> getPreviousDocs(final @Nonnull String property, final @Nullable Revision revision) {
        if (this.getPreviousRanges().isEmpty()) {
            return Collections.emptyList();
        }
        if (revision == null) {
            return new PropertyHistory(this.store, this, property);
        }
        String mainPath = this.getMainPath();
        Map.Entry<Revision, Range> entry = this.getPreviousRanges().floorEntry(revision);
        if (entry != null) {
            int h;
            Revision r = entry.getKey();
            String prevId = Utils.getPreviousIdFor(mainPath, r, h = entry.getValue().height);
            NodeDocument prev = this.store.find(Collection.NODES, prevId);
            if (prev != null) {
                if (prev.getValueMap(property).containsKey(revision)) {
                    return Collections.singleton(prev);
                }
            } else {
                LOG.warn("Document with previous revisions not found: " + prevId);
            }
        }
        return Iterables.filter(Iterables.transform(this.getPreviousRanges().headMap(revision).entrySet(), new Function<Map.Entry<Revision, Range>, NodeDocument>(){

            @Override
            public NodeDocument apply(Map.Entry<Revision, Range> input) {
                if (input.getValue().includes(revision)) {
                    return NodeDocument.this.getPreviousDoc(input.getKey(), input.getValue());
                }
                return null;
            }
        }), new Predicate<NodeDocument>(){

            @Override
            public boolean apply(@Nullable NodeDocument input) {
                return input != null && input.getValueMap(property).containsKey(revision);
            }
        });
    }

    @Nonnull
    Iterator<NodeDocument> getAllPreviousDocs() {
        if (this.getPreviousRanges().isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new AbstractIterator<NodeDocument>(){
            private Queue<Map.Entry<Revision, Range>> previousRanges;
            {
                this.previousRanges = Queues.newArrayDeque(NodeDocument.this.getPreviousRanges().entrySet());
            }

            @Override
            protected NodeDocument computeNext() {
                Map.Entry<Revision, Range> e;
                NodeDocument prev;
                if (!this.previousRanges.isEmpty() && (prev = NodeDocument.this.getPreviousDoc((e = this.previousRanges.remove()).getKey(), e.getValue())) != null) {
                    this.previousRanges.addAll(prev.getPreviousRanges().entrySet());
                    return prev;
                }
                return (NodeDocument)this.endOfData();
            }
        };
    }

    private NodeDocument getPreviousDoc(Revision rev, Range range) {
        int h = range.height;
        String prevId = Utils.getPreviousIdFor(this.getMainPath(), rev, h);
        NodeDocument prev = this.store.find(Collection.NODES, prevId);
        if (prev != null) {
            return prev;
        }
        LOG.warn("Document with previous revisions not found: " + prevId);
        return null;
    }

    @Nonnull
    SortedMap<Revision, String> getLocalMap(String key) {
        SortedMap<Revision, String> map = (SortedMap<Revision, String>)this.data.get(key);
        if (map == null) {
            map = ValueMap.EMPTY;
        }
        return map;
    }

    @Nonnull
    SortedMap<Revision, String> getLocalRevisions() {
        return this.getLocalMap(REVISIONS);
    }

    @Nonnull
    SortedMap<Revision, String> getLocalCommitRoot() {
        return this.getLocalMap(COMMIT_ROOT);
    }

    @Nonnull
    SortedMap<Revision, String> getLocalDeleted() {
        return this.getLocalMap(DELETED);
    }

    public static void setChildrenFlag(@Nonnull UpdateOp op, boolean hasChildNode) {
        Preconditions.checkNotNull(op).set(CHILDREN_FLAG, hasChildNode);
    }

    public static void setModified(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).set(MODIFIED_IN_SECS, Commit.getModifiedInSecs(Preconditions.checkNotNull(revision).getTimestamp()));
    }

    public static void setRevision(@Nonnull UpdateOp op, @Nonnull Revision revision, @Nonnull String commitValue) {
        Preconditions.checkNotNull(op).setMapEntry(REVISIONS, Preconditions.checkNotNull(revision), Preconditions.checkNotNull(commitValue));
    }

    public static void unsetRevision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).unsetMapEntry(REVISIONS, Preconditions.checkNotNull(revision));
    }

    public static boolean isRevisionsEntry(String name) {
        return REVISIONS.equals(name);
    }

    public static void removeRevision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(REVISIONS, Preconditions.checkNotNull(revision));
    }

    public static void removeCollision(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(COLLISIONS, Preconditions.checkNotNull(revision));
    }

    public static void setLastRev(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).setMapEntry(LAST_REV, new Revision(0L, 0, revision.getClusterId()), revision.toString());
    }

    public static boolean hasLastRev(@Nonnull UpdateOp op, int clusterId) {
        return Preconditions.checkNotNull(op).getChanges().containsKey(new UpdateOp.Key(LAST_REV, new Revision(0L, 0, clusterId)));
    }

    public static void unsetLastRev(@Nonnull UpdateOp op, int clusterId) {
        Preconditions.checkNotNull(op).unsetMapEntry(LAST_REV, new Revision(0L, 0, clusterId));
    }

    public static void setCommitRoot(@Nonnull UpdateOp op, @Nonnull Revision revision, int commitRootDepth) {
        Preconditions.checkNotNull(op).setMapEntry(COMMIT_ROOT, Preconditions.checkNotNull(revision), String.valueOf(commitRootDepth));
    }

    public static void removeCommitRoot(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(COMMIT_ROOT, revision);
    }

    public static void setDeleted(@Nonnull UpdateOp op, @Nonnull Revision revision, boolean deleted) {
        if (deleted) {
            Preconditions.checkNotNull(op).set(DELETED_ONCE, Boolean.TRUE);
        }
        Preconditions.checkNotNull(op).setMapEntry(DELETED, Preconditions.checkNotNull(revision), String.valueOf(deleted));
    }

    public static void removeDeleted(@Nonnull UpdateOp op, @Nonnull Revision revision) {
        Preconditions.checkNotNull(op).removeMapEntry(DELETED, revision);
    }

    public static void setPrevious(@Nonnull UpdateOp op, @Nonnull Range range) {
        Preconditions.checkNotNull(op).setMapEntry(PREVIOUS, Preconditions.checkNotNull(range).high, range.getLowValue());
    }

    public static void removePrevious(@Nonnull UpdateOp op, @Nonnull Range range) {
        Preconditions.checkNotNull(op).removeMapEntry(PREVIOUS, Preconditions.checkNotNull(range).high);
    }

    public static void setHasBinary(@Nonnull UpdateOp op) {
        Preconditions.checkNotNull(op).set(HAS_BINARY_FLAG, 1L);
    }

    private static void setSplitDocType(@Nonnull UpdateOp op, @Nonnull SplitDocType type) {
        Preconditions.checkNotNull(op).set(SD_TYPE, type.type);
    }

    private static void setSplitDocMaxRev(@Nonnull UpdateOp op, @Nonnull Revision maxRev) {
        Preconditions.checkNotNull(op).set(SD_MAX_REV_TIME_IN_SECS, Commit.getModifiedInSecs(maxRev.getTimestamp()));
    }

    @CheckForNull
    private NodeDocument getCommitRoot(@Nonnull Revision rev) {
        if (this.containsRevision(rev)) {
            return this;
        }
        String commitRootPath = this.getCommitRootPath(rev);
        if (commitRootPath == null) {
            return null;
        }
        return this.store.find(Collection.NODES, Utils.getIdFromPath(commitRootPath));
    }

    @CheckForNull
    private String getCommitRootDepth(@Nonnull Revision revision) {
        String depth;
        block1: {
            NodeDocument prev;
            SortedMap<Revision, String> local = this.getLocalCommitRoot();
            depth = (String)local.get(revision);
            if (depth != null) break block1;
            Iterator<NodeDocument> i$ = this.getPreviousDocs(COMMIT_ROOT, revision).iterator();
            while (i$.hasNext() && (depth = (prev = i$.next()).getCommitRootDepth(revision)) == null) {
            }
        }
        return depth;
    }

    private static void setSplitDocProps(NodeDocument mainDoc, NodeDocument oldDoc, UpdateOp old, Revision maxRev) {
        NodeDocument.setSplitDocMaxRev(old, maxRev);
        SplitDocType type = SplitDocType.DEFAULT;
        if (!mainDoc.hasChildren() && !NodeDocument.referencesOldDocAfterSplit(mainDoc, oldDoc)) {
            type = SplitDocType.DEFAULT_NO_CHILD;
        } else if (oldDoc.getLocalRevisions().isEmpty()) {
            type = SplitDocType.PROP_COMMIT_ONLY;
        }
        if (mainDoc.hasBinary()) {
            NodeDocument.setHasBinary(old);
        }
        NodeDocument.setSplitDocType(old, type);
    }

    private static boolean referencesOldDocAfterSplit(NodeDocument mainDoc, NodeDocument oldDoc) {
        Set<Revision> revs = oldDoc.getLocalRevisions().keySet();
        for (String property : mainDoc.data.keySet()) {
            if (IGNORE_ON_SPLIT.contains(property)) continue;
            HashSet<Revision> changes = Sets.newHashSet(mainDoc.getLocalMap(property).keySet());
            changes.removeAll(oldDoc.getLocalMap(property).keySet());
            if (Collections.disjoint(changes, revs)) continue;
            return true;
        }
        return false;
    }

    private static void setIntermediateDocProps(UpdateOp intermediate, Revision maxRev) {
        NodeDocument.setSplitDocMaxRev(intermediate, maxRev);
        NodeDocument.setSplitDocType(intermediate, SplitDocType.INTERMEDIATE);
    }

    private static boolean isRevisionNewer(@Nonnull RevisionContext context, @Nonnull Revision x, @Nonnull Revision previous) {
        return context.getRevisionComparator().compare(x, previous) > 0;
    }

    private boolean isCommitted(@Nonnull RevisionContext context, @Nonnull Revision revision, @Nullable String commitValue, @Nonnull Revision readRevision) {
        if (revision.equalsIgnoreBranch(readRevision)) {
            return true;
        }
        if (commitValue == null) {
            commitValue = this.getCommitValue(revision);
        }
        if (commitValue == null) {
            return false;
        }
        if (Utils.isCommitted(commitValue)) {
            if (context.getBranches().getBranch(readRevision) == null && !readRevision.isBranch()) {
                return !NodeDocument.isRevisionNewer(context, revision = Utils.resolveCommitRevision(revision, commitValue), readRevision);
            }
            if (commitValue.equals(this.getCommitValue(readRevision.asTrunkRevision()))) {
                return !NodeDocument.isRevisionNewer(context, revision, readRevision);
            }
        } else if (Revision.fromString(commitValue).getClusterId() != context.getClusterId()) {
            return false;
        }
        return NodeDocument.includeRevision(context, Utils.resolveCommitRevision(revision, commitValue), readRevision);
    }

    @CheckForNull
    private String getCommitValue(Revision revision) {
        String value;
        block1: {
            NodeDocument prev;
            value = (String)this.getLocalRevisions().get(revision);
            if (value != null) break block1;
            Iterator<NodeDocument> i$ = this.getPreviousDocs(REVISIONS, revision).iterator();
            while (i$.hasNext() && (value = (prev = i$.next()).getCommitValue(revision)) == null) {
            }
        }
        return value;
    }

    private static boolean includeRevision(RevisionContext context, Revision x, Revision requestRevision) {
        Branch b = context.getBranches().getBranch(x);
        if (b != null) {
            if (b.containsCommit(requestRevision)) {
                return x.equalsIgnoreBranch(requestRevision) || NodeDocument.isRevisionNewer(context, requestRevision, x);
            }
            return false;
        }
        b = context.getBranches().getBranch(requestRevision);
        if (b != null) {
            requestRevision = b.getBase(requestRevision);
        }
        return context.getRevisionComparator().compare(requestRevision, x) >= 0;
    }

    @CheckForNull
    private Value getLatestValue(@Nonnull RevisionContext context, @Nonnull Map<Revision, String> valueMap, @Nullable Revision min, @Nonnull Revision readRevision, @Nonnull Map<Revision, String> validRevisions) {
        String value = null;
        Revision latestRev = null;
        for (Map.Entry<Revision, String> entry : valueMap.entrySet()) {
            NodeDocument commitRoot;
            String commitValue;
            Revision propRev = entry.getKey();
            if (NodeDocument.isRevisionNewer(context, propRev, readRevision) || (commitValue = validRevisions.get(propRev)) == null && ((commitRoot = this.getCommitRoot(propRev)) == null || (commitValue = commitRoot.getCommitValue(propRev)) == null) || min != null && NodeDocument.isRevisionNewer(context, min, Utils.resolveCommitRevision(propRev, commitValue)) || !this.isValidRevision(context, propRev, commitValue, readRevision, validRevisions)) continue;
            latestRev = Utils.resolveCommitRevision(propRev, commitValue);
            value = entry.getValue();
            break;
        }
        return value != null ? new Value(value, latestRev) : null;
    }

    @Override
    public String getPath() {
        String p = (String)this.get(PATH);
        if (p != null) {
            return p;
        }
        return Utils.getPathFromId(this.getId());
    }

    @Nonnull
    private Map<Revision, String> getDeleted() {
        return ValueMap.create(this, DELETED);
    }

    static {
        NULL.seal();
        LOG = LoggerFactory.getLogger(NodeDocument.class);
        EMPTY_RANGE_MAP = Maps.unmodifiableNavigableMap(new TreeMap());
        IGNORE_ON_SPLIT = ImmutableSet.of("_id", "_modCount", MODIFIED_IN_SECS, PREVIOUS, LAST_REV, CHILDREN_FLAG, new String[]{HAS_BINARY_FLAG, PATH, DELETED_ONCE});
    }

    private static final class Value {
        final String value;
        final Revision revision;

        Value(@Nonnull String value, @Nonnull Revision revision) {
            this.value = Preconditions.checkNotNull(value);
            this.revision = Preconditions.checkNotNull(revision);
        }
    }

    static final class Children
    implements CacheValue,
    Cloneable {
        ArrayList<String> childNames = new ArrayList();
        boolean isComplete;

        Children() {
        }

        @Override
        public int getMemory() {
            int size = 114;
            for (String name : this.childNames) {
                size += name.length() * 2 + 56;
            }
            return size;
        }

        public Children clone() {
            try {
                Children clone = (Children)super.clone();
                clone.childNames = (ArrayList)this.childNames.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException();
            }
        }
    }

    public static enum SplitDocType {
        NONE(-1),
        DEFAULT(10),
        DEFAULT_NO_CHILD(20),
        PROP_COMMIT_ONLY(30),
        INTERMEDIATE(40);

        final int type;

        private SplitDocType(int type) {
            this.type = type;
        }

        public int typeCode() {
            return this.type;
        }

        static SplitDocType valueOf(Integer type) {
            if (type == null) {
                return NONE;
            }
            for (SplitDocType docType : SplitDocType.values()) {
                if (docType.type != type) continue;
                return docType;
            }
            throw new IllegalArgumentException("Not a valid SplitDocType :" + type);
        }
    }
}

