/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.security.Principal;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

public class PrincipalManagerDelegator
implements PrincipalManager {
    private final SessionDelegate delegate;
    private final PrincipalManager principalManager;

    public PrincipalManagerDelegator(SessionDelegate delegate, PrincipalManager principalManager) {
        this.principalManager = principalManager;
        this.delegate = delegate;
    }

    @Override
    public boolean hasPrincipal(final String principalName) {
        return this.delegate.safePerform(new SessionOperation<Boolean>("hasPrincipal"){

            @Override
            public Boolean perform() {
                return PrincipalManagerDelegator.this.principalManager.hasPrincipal(principalName);
            }
        });
    }

    @Override
    public Principal getPrincipal(final String principalName) {
        return this.delegate.safePerform(new SessionOperation<Principal>("getPrincipal"){

            @Override
            public Principal perform() {
                return PrincipalManagerDelegator.this.principalManager.getPrincipal(principalName);
            }
        });
    }

    @Override
    public PrincipalIterator findPrincipals(final String simpleFilter) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("findPrincipals"){

            @Override
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.findPrincipals(simpleFilter);
            }
        });
    }

    @Override
    public PrincipalIterator findPrincipals(final String simpleFilter, final int searchType) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("findPrincipals"){

            @Override
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.findPrincipals(simpleFilter, searchType);
            }
        });
    }

    @Override
    public PrincipalIterator getPrincipals(final int searchType) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("getPrincipals"){

            @Override
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.getPrincipals(searchType);
            }
        });
    }

    @Override
    public PrincipalIterator getGroupMembership(final Principal principal) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("getGroupMembership"){

            @Override
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.getGroupMembership(principal);
            }
        });
    }

    @Override
    public Principal getEveryone() {
        return this.delegate.safePerform(new SessionOperation<Principal>("getEveryone"){

            @Override
            public Principal perform() {
                return PrincipalManagerDelegator.this.principalManager.getEveryone();
            }
        });
    }
}

