/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class MessageDialog
extends Dialog
implements ActionListener,
KeyListener,
WindowListener {
    protected Button button;
    protected MultiLineLabel label;
    private boolean escapePressed;

    public MessageDialog(Frame parent, String title, String message) {
        super(parent, title, true);
        this.setLayout(new BorderLayout());
        if (message == null) {
            message = "";
        }
        this.label = new MultiLineLabel(message);
        if (!IJ.isLinux()) {
            this.label.setFont(new Font("SansSerif", 0, 14));
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 15, 15));
        panel.add(this.label);
        this.add("Center", panel);
        this.button = new Button("  OK  ");
        this.button.addActionListener(this);
        this.button.addKeyListener(this);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(this.button);
        this.add("South", panel);
        if (IJ.isMacintosh()) {
            this.setResizable(false);
        }
        this.pack();
        GUI.center(this);
        this.addWindowListener(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        boolean bl = this.escapePressed = keyCode == 27;
        if (keyCode == 10 || this.escapePressed) {
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public boolean escapePressed() {
        return this.escapePressed;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

