/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Toolbar;

public class FreehandRoi
extends PolygonRoi {
    public FreehandRoi(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        this.type = Toolbar.getToolId() == 3 ? 3 : 7;
        if (this.nPoints == 2) {
            --this.nPoints;
        }
    }

    protected void grow(int sx, int sy) {
        if (this.subPixelResolution() && this.xpf != null) {
            this.growFloat(sx, sy);
            return;
        }
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        if (ox < 0) {
            ox = 0;
        }
        if (oy < 0) {
            oy = 0;
        }
        if (ox > this.xMax) {
            ox = this.xMax;
        }
        if (oy > this.yMax) {
            oy = this.yMax;
        }
        if (ox != this.xp[this.nPoints - 1] + this.x || oy != this.yp[this.nPoints - 1] + this.y) {
            this.xp[this.nPoints] = ox - this.x;
            this.yp[this.nPoints] = oy - this.y;
            ++this.nPoints;
            if (this.nPoints == this.xp.length) {
                this.enlargeArrays();
            }
            this.drawLine();
        }
    }

    private void growFloat(int sx, int sy) {
        double ox = this.ic.offScreenXD(sx);
        double oy = this.ic.offScreenYD(sy);
        if (ox < 0.0) {
            ox = 0.0;
        }
        if (oy < 0.0) {
            oy = 0.0;
        }
        if (ox > (double)this.xMax) {
            ox = this.xMax;
        }
        if (oy > (double)this.yMax) {
            oy = this.yMax;
        }
        if (ox != (double)(this.xpf[this.nPoints - 1] + (float)this.x) || oy != (double)(this.ypf[this.nPoints - 1] + (float)this.y)) {
            this.xpf[this.nPoints] = (float)(ox - (double)this.x);
            this.ypf[this.nPoints] = (float)(oy - (double)this.y);
            ++this.nPoints;
            if (this.nPoints == this.xpf.length) {
                this.enlargeArrays();
            }
            this.drawLine();
        }
    }

    void drawLine() {
        double mag;
        int y2;
        int x2;
        int y1;
        int x1;
        if (this.xpf != null) {
            x1 = (int)this.xpf[this.nPoints - 2] + this.x;
            y1 = (int)this.ypf[this.nPoints - 2] + this.y;
            x2 = (int)this.xpf[this.nPoints - 1] + this.x;
            y2 = (int)this.ypf[this.nPoints - 1] + this.y;
        } else {
            x1 = this.xp[this.nPoints - 2] + this.x;
            y1 = this.yp[this.nPoints - 2] + this.y;
            x2 = this.xp[this.nPoints - 1] + this.x;
            y2 = this.yp[this.nPoints - 1] + this.y;
        }
        int xmin = Math.min(x1, x2);
        int xmax = Math.max(x1, x2);
        int ymin = Math.min(y1, y2);
        int ymax = Math.max(y1, y2);
        int margin = 4;
        if (lineWidth > margin && this.isLine()) {
            margin = lineWidth;
        }
        if (this.ic != null && (mag = this.ic.getMagnification()) < 1.0) {
            margin = (int)((double)margin / mag);
        }
        this.imp.draw(xmin - margin, ymin - margin, xmax - xmin + margin * 2, ymax - ymin + margin * 2);
    }

    protected void handleMouseUp(int screenX, int screenY) {
        if (this.state == 0) {
            this.addOffset();
            this.finishPolygon();
        }
        this.state = 3;
    }
}

