/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.insert.storage.plugin;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.Map;
import java.util.UUID;
import org.gcube.accounting.insert.storage.persistence.AggregatorPersistenceBackendQueryConfiguration;
import org.gcube.accounting.insert.storage.plugin.AccountingInsertStoragePluginDeclaration;
import org.gcube.accounting.insert.storage.utils.Constant;
import org.gcube.accounting.insert.storage.utils.DiscoveryListUser;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.documentstore.persistence.PersistenceCouchBase;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingInsertStoragePlugin
extends Plugin<AccountingInsertStoragePluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(AccountingInsertStoragePlugin.class);
    protected static final CouchbaseEnvironment ENV = DefaultCouchbaseEnvironment.builder().connectTimeout((long)(Constant.CONNECTION_TIMEOUT * 1000)).maxRequestLifetime((long)(Constant.MAX_REQUEST_LIFE_TIME * 1000)).queryTimeout((long)(Constant.CONNECTION_TIMEOUT * 1000)).viewTimeout((long)(Constant.VIEW_TIMEOUT_BUCKET * 1000)).keepAliveInterval(3600000L).kvTimeout(5000L).build();

    public AccountingInsertStoragePlugin(AccountingInsertStoragePluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        String context = ScopeProvider.instance.get();
        logger.debug("launch on context:{}", (Object)context);
        String url = null;
        String password = null;
        String bucket = null;
        try {
            AggregatorPersistenceBackendQueryConfiguration configuration = new AggregatorPersistenceBackendQueryConfiguration(PersistenceCouchBase.class);
            url = configuration.getProperty("URL");
            password = configuration.getProperty("password");
            bucket = configuration.getProperty("AggregatedStorageStatusRecord");
        }
        catch (Exception e) {
            logger.error("launch", (Object)e.getLocalizedMessage());
            throw e;
        }
        CouchbaseCluster cluster = CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
        Bucket accountingBucket = cluster.openBucket(bucket, password);
        String urlService = null;
        if (inputs.containsKey("urlService")) {
            urlService = (String)inputs.get("urlService");
        }
        String dataServiceClass = "content-management";
        if (inputs.containsKey("dataServiceClass")) {
            dataServiceClass = (String)inputs.get("dataServiceClass");
        }
        String dataServiceName = "storage-manager";
        if (inputs.containsKey("dataServiceName")) {
            dataServiceName = (String)inputs.get("dataServiceName");
        }
        String dataServiceId = "identifier";
        if (inputs.containsKey("dataServiceId")) {
            dataServiceId = (String)inputs.get("dataServiceId");
        }
        String uri = "MongoDb";
        if (inputs.containsKey("uri")) {
            uri = (String)inputs.get("uri");
        }
        String dataType = "STORAGE";
        if (inputs.containsKey("dataType")) {
            dataType = (String)inputs.get("dataType");
        }
        Integer timeWait = 1000;
        if (inputs.containsKey("timeWait")) {
            timeWait = (Integer)inputs.get("timeWait");
        }
        DiscoveryListUser discoveryListUser = new DiscoveryListUser(context, urlService);
        JsonDocument document = null;
        JsonObject content = null;
        for (String consumerId : discoveryListUser.getListUser()) {
            IClient client = new StorageClient("", "", consumerId, AccessType.PUBLIC, MemoryType.PERSISTENT).getClient();
            try {
                String docId = UUID.randomUUID().toString();
                Long dataVolume = Long.parseLong(client.getTotalUserVolume());
                Long dataCount = Long.parseLong(client.getUserTotalItems());
                Long timeStamp = System.currentTimeMillis();
                content = JsonObject.empty().put("scope", context);
                content.put("operationCount", 1);
                content.put("dataCount", (Object)dataCount);
                content.put("endTime", (Object)timeStamp);
                content.put("consumerId", consumerId);
                content.put("startTime", (Object)timeStamp);
                content.put("id", docId);
                content.put("dataVolume", (Object)dataVolume);
                content.put("dataType", dataType);
                content.put("operationResult", "SUCCESS");
                content.put("dataServiceClass", dataServiceClass);
                content.put("dataServiceName", dataServiceName);
                content.put("dataServiceId", dataServiceId);
                content.put("aggregated", true);
                content.put("providerId", uri);
                content.put("creationTime", (Object)timeStamp);
                content.put("recordType", "StorageStatusRecord");
                document = JsonDocument.create((String)"docId", (JsonObject)content);
                JsonDocument doc = JsonDocument.create((String)docId, (JsonObject)content);
                JsonDocument response = (JsonDocument)accountingBucket.upsert((Document)doc);
                Thread.sleep(timeWait.intValue());
            }
            catch (Exception e) {
                logger.error("doc:{} not insert ({}), problem with exist bucket", new Object[]{document.id(), document.toString(), e});
                logger.error("force insert into list for insert");
            }
        }
        cluster.disconnect();
    }

    protected void onStop() throws Exception {
        logger.trace("{} onStop() function", (Object)((Object)((Object)this)).getClass().getSimpleName());
        Thread.currentThread().interrupt();
    }
}

