/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRestore;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRAccountingEntryRestore
extends JCRAccountingEntry
implements AccountingEntryRestore {
    protected String itemName;

    public JCRAccountingEntryRestore(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML(node.getAccountingProperties().get((Object)AccountingProperty.ITEM_NAME));
    }

    public JCRAccountingEntryRestore(String id, String user, Calendar date, String nodeName) {
        super(id, user, date);
        this.itemName = nodeName;
        Map<AccountingProperty, String> properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML(this.itemName));
        this.entryDelegate.setEntryType(AccountingEntryType.RESTORE);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.RESTORE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s, itemName:%s]]", new Object[]{parentValue, this.getEntryType(), this.getItemName()});
    }

    @Override
    public String getItemName() {
        return this.itemName;
    }
}

