/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public interface QueryIndex {
    public double getCost(Filter var1, NodeState var2);

    public Cursor query(Filter var1, NodeState var2);

    public String getPlan(Filter var1, NodeState var2);

    public String getIndexName();

    public static class OrderEntry {
        private final String propertyName;
        private final Type<?> propertyType;
        private final Order order;

        public OrderEntry(String propertyName, Type<?> propertyType, Order order) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.order = order;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Order getOrder() {
            return this.order;
        }

        public Type<?> getPropertyType() {
            return this.propertyType;
        }

        public String toString() {
            return String.format("{ propertyName : %s, propertyType : %s, order : %s }", new Object[]{this.propertyName, this.propertyType, this.order});
        }

        public static enum Order {
            ASCENDING,
            DESCENDING;

        }
    }

    public static interface IndexPlan {
        public double getCostPerExecution();

        public double getCostPerEntry();

        public long getEstimatedEntryCount();

        public Filter getFilter();

        public void setFilter(Filter var1);

        public boolean isDelayed();

        public boolean isFulltextIndex();

        public boolean includesNodeData();

        public List<OrderEntry> getSortOrder();

        public static class Builder {
            protected double costPerExecution = 1.0;
            protected double costPerEntry = 1.0;
            protected long estimatedEntryCount = 1000000L;
            protected Filter filter;
            protected boolean isDelayed;
            protected boolean isFulltextIndex;
            protected boolean includesNodeData;
            protected List<OrderEntry> sortOrder;

            public Builder setCostPerExecution(double costPerExecution) {
                this.costPerExecution = costPerExecution;
                return this;
            }

            public Builder setCostPerEntry(double costPerEntry) {
                this.costPerEntry = costPerEntry;
                return this;
            }

            public Builder setEstimatedEntryCount(long estimatedEntryCount) {
                this.estimatedEntryCount = estimatedEntryCount;
                return this;
            }

            public Builder setFilter(Filter filter) {
                this.filter = filter;
                return this;
            }

            public Builder setDelayed(boolean isDelayed) {
                this.isDelayed = isDelayed;
                return this;
            }

            public Builder setFulltextIndex(boolean isFulltextIndex) {
                this.isFulltextIndex = isFulltextIndex;
                return this;
            }

            public Builder setIncludesNodeData(boolean includesNodeData) {
                this.includesNodeData = includesNodeData;
                return this;
            }

            public Builder setSortOrder(List<OrderEntry> sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            public IndexPlan build() {
                return new IndexPlan(){
                    private final double costPerExecution;
                    private final double costPerEntry;
                    private final long estimatedEntryCount;
                    private Filter filter;
                    private final boolean isDelayed;
                    private final boolean isFulltextIndex;
                    private final boolean includesNodeData;
                    private final List<OrderEntry> sortOrder;
                    {
                        this.costPerExecution = Builder.this.costPerExecution;
                        this.costPerEntry = Builder.this.costPerEntry;
                        this.estimatedEntryCount = Builder.this.estimatedEntryCount;
                        this.filter = Builder.this.filter;
                        this.isDelayed = Builder.this.isDelayed;
                        this.isFulltextIndex = Builder.this.isFulltextIndex;
                        this.includesNodeData = Builder.this.includesNodeData;
                        this.sortOrder = Builder.this.sortOrder == null ? null : new ArrayList<OrderEntry>(Builder.this.sortOrder);
                    }

                    public String toString() {
                        return String.format("{ costPerExecution : %s, costPerEntry : %s, estimatedEntryCount : %s, filter : %s, isDelayed : %s, isFulltextIndex : %s, includesNodeData : %s, sortOrder : %s }", this.costPerExecution, this.costPerEntry, this.estimatedEntryCount, this.filter, this.isDelayed, this.isFulltextIndex, this.includesNodeData, this.sortOrder);
                    }

                    @Override
                    public double getCostPerExecution() {
                        return this.costPerExecution;
                    }

                    @Override
                    public double getCostPerEntry() {
                        return this.costPerEntry;
                    }

                    @Override
                    public long getEstimatedEntryCount() {
                        return this.estimatedEntryCount;
                    }

                    @Override
                    public Filter getFilter() {
                        return this.filter;
                    }

                    @Override
                    public void setFilter(Filter filter) {
                        this.filter = filter;
                    }

                    @Override
                    public boolean isDelayed() {
                        return this.isDelayed;
                    }

                    @Override
                    public boolean isFulltextIndex() {
                        return this.isFulltextIndex;
                    }

                    @Override
                    public boolean includesNodeData() {
                        return this.includesNodeData;
                    }

                    @Override
                    public List<OrderEntry> getSortOrder() {
                        return this.sortOrder;
                    }
                };
            }
        }
    }

    public static interface AdvancedQueryIndex {
        public List<IndexPlan> getPlans(Filter var1, List<OrderEntry> var2, NodeState var3);

        public String getPlanDescription(IndexPlan var1);

        public Cursor query(IndexPlan var1, NodeState var2);
    }

    public static interface FulltextQueryIndex
    extends QueryIndex {
        @CheckForNull
        public NodeAggregator getNodeAggregator();
    }
}

