/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SubtreeValidator
extends DefaultValidator {
    private final Validator validator;
    private final String head;
    private final List<String> tail;

    public SubtreeValidator(Validator validator, String ... path) {
        this(validator, Arrays.asList(path));
    }

    private SubtreeValidator(Validator validator, List<String> path) {
        this.validator = Preconditions.checkNotNull(validator);
        Preconditions.checkNotNull(path);
        Preconditions.checkArgument(!path.isEmpty());
        this.head = path.get(0);
        this.tail = path.subList(1, path.size());
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) {
        return this.descend(name);
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) {
        return this.descend(name);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) {
        return this.descend(name);
    }

    private Validator descend(String name) {
        if (!this.head.equals(name)) {
            return null;
        }
        if (this.tail.isEmpty()) {
            return this.validator;
        }
        return new SubtreeValidator(this.validator, this.tail);
    }
}

