/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.fulltext.SimpleExcerptProvider;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;

public class ResultRowImpl
implements ResultRow {
    private final Query query;
    private final Tree[] trees;
    private final PropertyValue[] values;
    private final boolean[] distinctValues;
    private final PropertyValue[] orderValues;

    ResultRowImpl(Query query, Tree[] trees, PropertyValue[] values, boolean[] distinctValues, PropertyValue[] orderValues) {
        this.query = query;
        this.trees = trees;
        this.values = values;
        this.distinctValues = distinctValues;
        this.orderValues = orderValues;
    }

    PropertyValue[] getOrderValues() {
        return this.orderValues;
    }

    @Override
    public String getPath() {
        return this.getPath(null);
    }

    @Override
    public String getPath(String selectorName) {
        Tree tree = this.getTree(selectorName);
        if (tree != null) {
            return tree.getPath();
        }
        return null;
    }

    @Override
    public Tree getTree(String selectorName) {
        if (selectorName == null) {
            if (this.trees.length > 1) {
                throw new IllegalArgumentException("More than one selector");
            }
            if (this.trees.length == 0) {
                throw new IllegalArgumentException("This query does not have a selector");
            }
            return this.trees[0];
        }
        int index = this.query.getSelectorIndex(selectorName);
        if (this.trees == null || index >= this.trees.length) {
            return null;
        }
        return this.trees[index];
    }

    @Override
    public PropertyValue getValue(String columnName) {
        int index = this.query.getColumnIndex(columnName);
        if (index >= 0) {
            return this.values[index];
        }
        if ("jcr:path".equals(columnName)) {
            return PropertyValues.newString(this.getPath());
        }
        if (columnName.startsWith("rep:excerpt")) {
            String ex = SimpleExcerptProvider.getExcerpt(this.getPath(), columnName, this.query, true);
            if (ex != null) {
                return PropertyValues.newString(ex);
            }
            return PropertyValues.newString(this.getPath());
        }
        throw new IllegalArgumentException("Column not found: " + columnName);
    }

    @Override
    public PropertyValue[] getValues() {
        PropertyValue[] v2 = new PropertyValue[this.values.length];
        System.arraycopy(this.values, 0, v2, 0, this.values.length);
        return v2;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (String s : this.query.getSelectorNames()) {
            String p = this.getPath(s);
            if (p == null) continue;
            buff.append(s).append(": ").append(p).append(" ");
        }
        ColumnImpl[] cols = this.query.getColumns();
        for (int i = 0; i < this.values.length; ++i) {
            ColumnImpl c = cols[i];
            String n = c.getColumnName();
            if (n == null) continue;
            buff.append(n).append(": ").append(this.values[i]).append(" ");
        }
        return buff.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getPaths());
        result = 31 * result + this.hashCodeOfValues();
        return result;
    }

    private int hashCodeOfValues() {
        int result = 1;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.distinctValues != null && !this.distinctValues[i]) continue;
            PropertyValue v = this.values[i];
            result = 31 * result + (v == null ? 0 : v.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != obj.getClass()) {
            return false;
        }
        ResultRowImpl other = (ResultRowImpl)obj;
        if (!Arrays.equals(this.getPaths(), other.getPaths())) {
            return false;
        }
        if (!Arrays.equals(this.distinctValues, other.distinctValues)) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.distinctValues != null && !this.distinctValues[i]) continue;
            PropertyValue o1 = this.values[i];
            PropertyValue o2 = other.values[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    private String[] getPaths() {
        String[] paths = new String[this.trees.length];
        for (int i = 0; i < this.trees.length; ++i) {
            paths[i] = this.trees[i] != null ? this.trees[i].getPath() : null;
        }
        return paths;
    }

    public static Comparator<ResultRowImpl> getComparator(final OrderingImpl[] orderings) {
        if (orderings == null) {
            return null;
        }
        return new Comparator<ResultRowImpl>(){

            @Override
            public int compare(ResultRowImpl o1, ResultRowImpl o2) {
                PropertyValue[] orderValues = o1.getOrderValues();
                PropertyValue[] orderValues2 = o2.getOrderValues();
                int comp = 0;
                int size = orderings.length;
                for (int i = 0; i < size; ++i) {
                    PropertyValue a = orderValues[i];
                    PropertyValue b = orderValues2[i];
                    comp = a == null || b == null ? (a == b ? 0 : (a == null ? -1 : 1)) : a.compareTo(b);
                    if (comp == 0) continue;
                    if (!orderings[i].isDescending()) break;
                    comp = -comp;
                    break;
                }
                return comp;
            }
        };
    }
}

