/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedIndex;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditor;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.OrderedContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedPropertyIndexEditor
extends PropertyIndexEditor {
    static final IndexStoreStrategy ORDERED_MIRROR = new OrderedContentMirrorStoreStrategy();
    static final IndexStoreStrategy ORDERED_MIRROR_DESCENDING = new OrderedContentMirrorStoreStrategy(OrderedIndex.OrderDirection.DESC);
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPropertyIndexEditor.class);
    private final Set<String> propertyNames;
    private boolean properlyConfigured;
    private OrderedIndex.OrderDirection direction = OrderedIndex.DEFAULT_DIRECTION;

    public OrderedPropertyIndexEditor(NodeBuilder definition, NodeState root, IndexUpdateCallback callback) {
        super(definition, root, callback);
        Set<String> pns = null;
        PropertyState names = definition.getProperty("propertyNames");
        if (names != null) {
            String value = names.getValue(Type.NAME, 0);
            if (Strings.isNullOrEmpty(value)) {
                LOG.warn("Empty value passed as propertyNames. Index not properly configured. Ignoring.");
            } else {
                if (names.isArray() && names.count() > 1) {
                    LOG.debug("Only single value supported. '{}' only will be used.", (Object)value);
                }
                pns = Collections.singleton(value);
                this.properlyConfigured = true;
            }
        }
        this.propertyNames = pns;
        String propertyDirection = definition.getString("direction");
        if (propertyDirection != null) {
            OrderedIndex.OrderDirection dir = OrderedIndex.OrderDirection.fromString(propertyDirection);
            if (dir == null) {
                LOG.warn("An unknown direction has been specified for sorting: '{}'. Using default one. {}", (Object)propertyDirection, (Object)this.direction);
            } else {
                this.direction = dir;
            }
        }
    }

    OrderedPropertyIndexEditor(OrderedPropertyIndexEditor parent, String name) {
        super(parent, name);
        this.propertyNames = parent.getPropertyNames();
        this.direction = parent.getDirection();
    }

    @Override
    IndexStoreStrategy getStrategy(boolean unique) {
        IndexStoreStrategy store = ORDERED_MIRROR;
        if (!OrderedIndex.DEFAULT_DIRECTION.equals((Object)this.getDirection())) {
            store = ORDERED_MIRROR_DESCENDING;
        }
        return store;
    }

    public boolean isProperlyConfigured() {
        return this.properlyConfigured;
    }

    @Override
    Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    PropertyIndexEditor getChildIndexEditor(@Nonnull PropertyIndexEditor parent, @Nonnull String name) {
        return new OrderedPropertyIndexEditor(this, name);
    }

    public OrderedIndex.OrderDirection getDirection() {
        return this.direction;
    }
}

