/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ErrorMap
implements Comparable<ErrorMap> {
    private final int version;
    private final int revision;
    private final Map<Short, ErrorCode> errors;

    @JsonCreator
    public ErrorMap(@JsonProperty(value="version") int version, @JsonProperty(value="revision") int revision, @JsonProperty(value="errors") Map<String, ErrorCode> errors) {
        this.version = version;
        this.revision = revision;
        this.errors = ErrorMap.toShortKeys(errors);
    }

    private static Map<Short, ErrorCode> toShortKeys(Map<String, ErrorCode> errors) {
        HashMap<Short, ErrorCode> result = new HashMap<Short, ErrorCode>(errors.size());
        for (Map.Entry<String, ErrorCode> entry : errors.entrySet()) {
            result.put(Short.parseShort(entry.getKey(), 16), entry.getValue());
        }
        return result;
    }

    @Override
    public int compareTo(ErrorMap o) {
        if (this.version < o.version()) {
            return -1;
        }
        if (this.version > o.version()) {
            return 1;
        }
        if (this.revision < o.revision()) {
            return -1;
        }
        if (this.revision > o.revision()) {
            return 1;
        }
        return 0;
    }

    public int version() {
        return this.version;
    }

    public int revision() {
        return this.revision;
    }

    public Map<Short, ErrorCode> errors() {
        return this.errors;
    }

    public String toString() {
        return "ErrorMap{version=" + this.version + ", revision=" + this.revision + ", errors=" + this.errors + '}';
    }

    public static enum ErrorAttribute {
        ITEM_ONLY("item-only"),
        INVALID_INPUT("invalid-input"),
        FETCH_CONFIG("fetch-config"),
        CONN_STATE_INVALIDATED("conn-state-invalidated"),
        AUTH("auth"),
        SPECIAL_HANDLING("special-handling"),
        SUPPORT("support"),
        TEMP("temp"),
        INTERNAL("internal"),
        RETRY_NOW("retry-now"),
        RETRY_LATER("retry-later"),
        SUBDOC("subdoc"),
        DCP("dcp");

        private final String raw;

        private ErrorAttribute(String raw) {
            this.raw = raw;
        }

        @JsonValue
        public String raw() {
            return this.raw;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ErrorCode {
        private final String name;
        private final String description;
        private final List<ErrorAttribute> attributes;

        @JsonCreator
        public ErrorCode(@JsonProperty(value="name") String name, @JsonProperty(value="desc") String description, @JsonProperty(value="attrs") List<ErrorAttribute> attributes) {
            this.name = name;
            this.description = description;
            this.attributes = attributes;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public List<ErrorAttribute> attributes() {
            return this.attributes;
        }

        public String toString() {
            return "ErrorCode{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", attributes=" + this.attributes + '}';
        }
    }
}

