/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.servlet;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.lock.JCRLockManager;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSession {
    private Map<String, GCoreEndpoint.Profile.Endpoint> servlets;
    private Logger logger = LoggerFactory.getLogger(JCRSession.class);
    private String login;
    private String sessionId;
    private JCRLockManager lockManager;

    public JCRSession(String login, Boolean createSession) throws RepositoryException {
        this.login = login;
        this.servlets = JCRRepository.servlets;
        if (createSession.booleanValue()) {
            this.sessionId = this.getSession();
        }
    }

    public String getLogin() {
        return this.login;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private String loginInfo() {
        StringBuilder loginInfo = new StringBuilder();
        loginInfo.append("?").append("uuid").append("=").append(this.sessionId);
        loginInfo.append("&").append("login").append("=").append(this.login);
        return loginInfo.toString();
    }

    private String getSession() throws RepositoryException {
        String uuid = null;
        HttpMethodBase getMethod = null;
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.servlets.get("CreateSession").uri().toString()) + this.loginInfo());
                TokenUtility.setHeader((GetMethod)getMethod);
                httpClient.executeMethod(getMethod);
                uuid = (String)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return uuid;
    }

    public void releaseSession() {
        if (this.sessionId != null) {
            HttpMethodBase getMethod = null;
            HttpClient httpClient = new HttpClient();
            try {
                try {
                    getMethod = new GetMethod(String.valueOf(this.servlets.get("ReleaseSession").uri().toString()) + this.loginInfo());
                    TokenUtility.setHeader((GetMethod)getMethod);
                    httpClient.executeMethod(getMethod);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    if (getMethod != null) {
                        getMethod.releaseConnection();
                    }
                }
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
    }

    public List<ItemDelegate> getChildrenById(String id, Boolean showHidden) throws RepositoryException {
        this.logger.debug("Calling servlet getChildrenById " + id + " by " + this.login);
        List items = null;
        HttpMethodBase getMethod = null;
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.servlets.get("GetChildrenById").uri().toString()) + this.loginInfo() + "&id=" + id + "&showHidden=" + showHidden);
                TokenUtility.setHeader((GetMethod)getMethod);
                httpClient.executeMethod(getMethod);
                items = (List)xstream.fromXML(new InputStreamReader(getMethod.getResponseBodyAsStream(), "UTF-8"));
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public List<ItemDelegate> GetHiddenItemsById(String id) throws RepositoryException {
        this.logger.debug("Calling servlet GetHiddenItemsById " + id + " by " + this.login);
        List items = null;
        HttpMethodBase getMethod = null;
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.servlets.get("GetHiddenItemsById").uri().toString()) + this.loginInfo() + "&id=" + id);
                TokenUtility.setHeader((GetMethod)getMethod);
                httpClient.executeMethod(getMethod);
                items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public Map<String, String> moveToTrashIds(List<String> ids, String trashId) throws RepositoryException {
        Validate.notNull(trashId, "trashId must be not null");
        Validate.notNull(ids, "ids must be not null");
        this.logger.debug("Calling Servlet MoveToTrashIds on " + ids.size() + " by " + this.login);
        Map error = null;
        HttpMethodBase post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            try {
                post = new PostMethod(String.valueOf(this.servlets.get("MoveToTrashIds").uri().toString()) + this.loginInfo() + "&trashId=" + trashId);
                TokenUtility.setHeader((PostMethod)post);
                ((EntityEnclosingMethod)post).setRequestEntity(new StringRequestEntity(xstream.toXML(ids), "application/json", null));
                int response = httpClient.executeMethod(post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
                error = (Map)xstream.fromXML(post.getResponseBodyAsStream());
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return error;
    }

    public ItemDelegate getItemByPath(String path) throws ItemNotFoundException {
        this.logger.debug("*** Calling Servlet GetItemByPath " + path + " by " + this.login);
        ItemDelegate item = null;
        HttpMethodBase getMethod = null;
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                System.out.println(String.valueOf(this.servlets.get("GetItemByPath").uri().toString()) + this.loginInfo() + "&path=" + URLEncoder.encode(path, "UTF-8"));
                getMethod = new GetMethod(String.valueOf(this.servlets.get("GetItemByPath").uri().toString()) + this.loginInfo() + "&path=" + URLEncoder.encode(path, "UTF-8"));
                TokenUtility.setHeader((GetMethod)getMethod);
                httpClient.executeMethod(getMethod);
                item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate getItemById(String id) throws ItemNotFoundException {
        this.logger.debug("Servlet getItemById " + id);
        ItemDelegate item = null;
        HttpMethodBase getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            try {
                System.out.println(String.valueOf(this.servlets.get("GetItemById").uri().toString()) + this.loginInfo() + "&id=" + id);
                getMethod = new GetMethod(String.valueOf(this.servlets.get("GetItemById").uri().toString()) + this.loginInfo() + "&id=" + id);
                TokenUtility.setHeader((GetMethod)getMethod);
                httpClient.executeMethod(getMethod);
                item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate getParentById(String id) throws ItemNotFoundException {
        this.logger.debug("Servlet getParentById " + id);
        ItemDelegate item = null;
        HttpMethodBase getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.servlets.get("GetParentById").uri().toString()) + this.loginInfo() + "&id=" + id);
                TokenUtility.setHeader((GetMethod)getMethod);
                httpClient.executeMethod(getMethod);
                item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate saveItem(ItemDelegate item, InputStream is) throws RepositoryException {
        Validate.notNull(item, "item must be not null");
        this.logger.debug("Calling Servlet SaveItem " + item.getName() + " by " + this.login);
        ItemDelegate modifiedItem = null;
        HttpMethodBase post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            try {
                post = new PostMethod(String.valueOf(this.servlets.get("SaveItem").uri().toString()) + this.loginInfo());
                TokenUtility.setHeader((PostMethod)post);
                ((EntityEnclosingMethod)post).setRequestEntity(new StringRequestEntity(xstream.toXML(item), "application/json", null));
                int response = httpClient.executeMethod(post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
                modifiedItem = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public ItemDelegate saveItem(ItemDelegate item) throws RepositoryException {
        return this.saveItem(item, false);
    }

    public ItemDelegate saveItem(ItemDelegate item, boolean createVersion) throws RepositoryException {
        Validate.notNull(item, "item must be not null");
        this.logger.debug("Calling Servlet SaveItem " + item.getName() + " by " + this.login);
        ItemDelegate modifiedItem = null;
        HttpMethodBase post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            try {
                post = new PostMethod(String.valueOf(this.servlets.get("SaveItem").uri().toString()) + this.loginInfo() + "&flag=" + createVersion);
                TokenUtility.setHeader((PostMethod)post);
                ((EntityEnclosingMethod)post).setRequestEntity(new StringRequestEntity(xstream.toXML(item), "application/json", null));
                int response = httpClient.executeMethod(post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
                modifiedItem = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public ItemDelegate clone(String srcAbsPath, String destAbsPath, boolean removeExisting) throws HttpException, IOException {
        this.logger.debug("Calling Servlet Clone from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            System.out.println(String.valueOf(this.servlets.get("Clone").uri().toString()) + this.loginInfo() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&removeExisting=" + removeExisting);
            getMethod = new GetMethod(String.valueOf(this.servlets.get("Clone").uri().toString()) + this.loginInfo() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&removeExisting=" + removeExisting);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod(getMethod);
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public ItemDelegate move(String srcAbsPath, String destAbsPath) throws HttpException, IOException {
        this.logger.debug("Calling Servlet Move from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        HttpMethodBase getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(String.valueOf(this.servlets.get("Move").uri().toString()) + this.loginInfo() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8"));
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public void removeItem(String absPath) throws RepositoryException {
        this.logger.debug("Calling Servlet RemoveItem " + absPath + " by " + this.login);
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        try {
            try {
                System.out.println(String.valueOf(this.servlets.get("RemoveItem").uri().toString()) + this.loginInfo() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8"));
                post = new PostMethod(String.valueOf(this.servlets.get("RemoveItem").uri().toString()) + this.loginInfo() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8"));
                TokenUtility.setHeader(post);
                int response = httpClient.executeMethod(post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Exception removing item " + absPath);
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public Boolean changePrimaryType(String id, String primaryType) throws RepositoryException {
        this.logger.debug("Calling Servlet ChangePrimaryType ID" + id + " primaryType " + primaryType + " by " + this.login);
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        Boolean changed = false;
        try {
            try {
                post = new PostMethod(String.valueOf(this.servlets.get("ChangePrimaryType").uri().toString()) + this.loginInfo() + "&id=" + id + "&primaryType=" + primaryType);
                TokenUtility.setHeader(post);
                int response = httpClient.executeMethod(post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
                changed = (Boolean)xstream.fromXML(post.getResponseBodyAsStream());
            }
            catch (IOException e) {
                throw new RepositoryException("Exception removing item " + id);
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return changed;
    }

    public ItemDelegate copy(String srcAbsPath, String destAbsPath, Boolean removeSubgraph) throws IOException {
        this.logger.debug("Calling Servlet Copy from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate item = null;
        GetMethod post = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            post = new GetMethod(String.valueOf(this.servlets.get("Copy").uri().toString()) + this.loginInfo() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&subgraph=" + removeSubgraph);
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod(post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate copyContent(String srcId, String destId) throws IOException {
        this.logger.debug("Calling Servlet CopyContent from id " + srcId + " to id " + destId + " by " + this.login);
        ItemDelegate item = null;
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            post = new PostMethod(String.valueOf(this.servlets.get("CopyContent").uri().toString()) + this.loginInfo() + "&srcId=" + srcId + "&destId=" + destId);
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod(post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    public List<SearchItemDelegate> executeQuery(String query, String lang, int limit) throws HttpException, IOException {
        this.logger.debug("Calling Servlet ExecuteQuery - query: " + query + " - lang: " + lang + " - limit: " + limit + " by " + this.login);
        HttpMethodBase get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(String.valueOf(this.servlets.get("ExecuteQuery").uri().toString()) + this.loginInfo() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang + "&limit=" + limit);
            TokenUtility.setHeader((GetMethod)get);
            int response = httpClient.executeMethod(get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    public List<ItemDelegate> searchItems(String query, String lang) throws HttpException, IOException {
        this.logger.debug("Calling Servlet SearchItems - query: " + query + " - lang: " + lang + " by " + this.login);
        HttpMethodBase get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(String.valueOf(this.servlets.get("SearchItems").uri().toString()) + this.loginInfo() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang);
            TokenUtility.setHeader((GetMethod)get);
            int response = httpClient.executeMethod(get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    public void saveAccountingItem(AccountingDelegate item) throws RepositoryException {
        Validate.notNull(item, "item must be not null");
        this.logger.debug("Calling Servlet SaveAccountingItem by " + this.login + " - " + item.getEntryType().toString() + " - " + item.getAccountingProperties().toString());
        HttpMethodBase post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            try {
                post = new PostMethod(String.valueOf(this.servlets.get("SaveAccountingItem").uri().toString()) + this.loginInfo());
                TokenUtility.setHeader((PostMethod)post);
                ((EntityEnclosingMethod)post).setRequestEntity(new StringRequestEntity(xstream.toXML(item), "application/json", null));
                int response = httpClient.executeMethod(post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public List<AccountingDelegate> getAccountingById(String id) throws RepositoryException {
        this.logger.debug("Calling Servlet GetAccountingById - id: " + id + " by " + this.login);
        List items = null;
        HttpMethodBase getMethod = null;
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.servlets.get("GetAccountingById").uri().toString()) + this.loginInfo() + "&id=" + id);
                TokenUtility.setHeader((GetMethod)getMethod);
                httpClient.executeMethod(getMethod);
                items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public ItemDelegate createReference(String itemId, String destinationFolderId) throws HttpException, IOException {
        this.logger.debug("Calling Servlet CreateReference of Node Id " + itemId + " to destination folder ID" + destinationFolderId + " by " + this.login);
        ItemDelegate modifiedItem = null;
        HttpMethodBase postMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            postMethod = new PostMethod(String.valueOf(this.servlets.get("CreateReference").uri().toString()) + this.loginInfo() + "&srcId=" + itemId + "&destId=" + destinationFolderId);
            TokenUtility.setHeader((PostMethod)postMethod);
            int response = httpClient.executeMethod(postMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(postMethod.getResponseBodyAsStream());
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public List<String> getReferences(String itemId) throws HttpException, IOException {
        Validate.notNull(itemId, "Item id must be not null");
        this.logger.debug("Calling Servlet CreateReference of Node Id " + itemId + " by " + this.login);
        List list = null;
        HttpMethodBase getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(String.valueOf(this.servlets.get("GetReferences").uri().toString()) + this.loginInfo() + "&srcId=" + itemId);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return list;
    }

    public JCRLockManager getLockManager() {
        if (this.lockManager == null) {
            this.lockManager = new JCRLockManager(this.login, this.sessionId);
        }
        return this.lockManager;
    }

    public List<ItemDelegate> getParentsById(String id) throws HttpException, IOException {
        Validate.notNull(id, "Item id must be not null");
        this.logger.debug("Calling Servlet get Parents By Id " + id + " by " + this.login);
        List parents = null;
        HttpMethodBase getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(String.valueOf(this.servlets.get("GetParentsById").uri().toString()) + this.loginInfo() + "&id=" + id);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            parents = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return parents;
    }

    public ItemDelegate addNode(ItemDelegate parent, String id) throws HttpException, IOException {
        this.logger.debug("Calling Servlet add node with id " + id + " to node " + parent.getPath());
        ItemDelegate item = null;
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            post = new PostMethod(String.valueOf(this.servlets.get("AddNode").uri().toString()) + this.loginInfo() + "&id=" + id + "&parentId=" + parent.getId());
            TokenUtility.setHeader(post);
            int response = httpClient.executeMethod(post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate createItem(ItemDelegate delegate, InputStream is) throws RepositoryException {
        Validate.notNull(delegate, "item must be not null");
        this.logger.debug("Calling Servlet SaveItem " + delegate.getName() + " by " + this.login);
        ItemDelegate modifiedItem = null;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        XStream xstream = new XStream(new DomDriver("UTF-8"));
        try {
            String description = "";
            if (delegate.getDescription() != null) {
                description = delegate.getDescription();
            }
            String parentPath = null;
            try {
                parentPath = this.getItemById(delegate.getParentId()).getPath();
            }
            catch (ItemNotFoundException e) {
                e.printStackTrace();
            }
            String uri = String.valueOf(this.servlets.get("CreateItem").uri().toString()) + this.loginInfo() + "&name=" + URLEncoder.encode(delegate.getName(), "UTF-8") + "&description=" + URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(parentPath, "UTF-8");
            HttpPost post = new HttpPost(uri);
            TokenUtility.setHeader(post);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("upstream", is);
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            CloseableHttpResponse httpResponse = client.execute(post);
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = EntityUtils.toString(httpEntity);
            modifiedItem = (ItemDelegate)xstream.fromXML(response);
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage());
        }
        return modifiedItem;
    }
}

