/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.api.stats.TimeSeries;

public class TimeSeriesMax
implements TimeSeries {
    private final MaxValue max = new MaxValue(0L);
    private final long[] perSecond = new long[60];
    private final long[] perMinute = new long[60];
    private final long[] perHour = new long[168];
    private final long[] perWeek = new long[156];
    private int seconds;
    private int minutes;
    private int hours;
    private int weeks;

    public TimeSeriesMax(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ((TimeSeriesMax)TimeSeriesMax.this).perSecond[((TimeSeriesMax)TimeSeriesMax.this).seconds++] = TimeSeriesMax.this.max.getAndSetValue(0L);
                if (TimeSeriesMax.this.seconds == TimeSeriesMax.this.perSecond.length) {
                    TimeSeriesMax.this.seconds = 0;
                    ((TimeSeriesMax)TimeSeriesMax.this).perMinute[((TimeSeriesMax)TimeSeriesMax.this).minutes++] = TimeSeriesMax.max(TimeSeriesMax.this.perSecond);
                }
                if (TimeSeriesMax.this.minutes == TimeSeriesMax.this.perMinute.length) {
                    TimeSeriesMax.this.minutes = 0;
                    ((TimeSeriesMax)TimeSeriesMax.this).perHour[((TimeSeriesMax)TimeSeriesMax.this).hours++] = TimeSeriesMax.max(TimeSeriesMax.this.perMinute);
                }
                if (TimeSeriesMax.this.hours == TimeSeriesMax.this.perHour.length) {
                    TimeSeriesMax.this.hours = 0;
                    ((TimeSeriesMax)TimeSeriesMax.this).perWeek[((TimeSeriesMax)TimeSeriesMax.this).weeks++] = TimeSeriesMax.max(TimeSeriesMax.this.perHour);
                }
                if (TimeSeriesMax.this.weeks == TimeSeriesMax.this.perWeek.length) {
                    TimeSeriesMax.this.weeks = 0;
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void recordValue(long value) {
        this.max.setIfMaximal(value);
    }

    @Override
    public synchronized long[] getValuePerSecond() {
        return TimeSeriesMax.cyclicCopyFrom(this.perSecond, this.seconds);
    }

    @Override
    public synchronized long[] getValuePerMinute() {
        return TimeSeriesMax.cyclicCopyFrom(this.perMinute, this.minutes);
    }

    @Override
    public synchronized long[] getValuePerHour() {
        return TimeSeriesMax.cyclicCopyFrom(this.perHour, this.hours);
    }

    @Override
    public synchronized long[] getValuePerWeek() {
        return TimeSeriesMax.cyclicCopyFrom(this.perWeek, this.weeks);
    }

    private static long max(long[] array) {
        long max = Long.MIN_VALUE;
        for (long v : array) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    private static long[] cyclicCopyFrom(long[] array, int pos) {
        long[] reverse = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            reverse[i] = array[(pos + i) % array.length];
        }
        return reverse;
    }

    private static class MaxValue {
        private long value;

        public MaxValue(long value) {
            this.value = value;
        }

        public synchronized long getAndSetValue(long value) {
            long v = this.value;
            this.value = value;
            return v;
        }

        public synchronized void setIfMaximal(long value) {
            if (value > this.value) {
                this.value = value;
            }
        }
    }
}

