/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.diffindex;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.diffindex.DiffCollector;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public abstract class BaseDiffCollector
implements DiffCollector {
    private final NodeState before;
    private final NodeState after;
    private Set<String> results;
    protected boolean init = false;

    public BaseDiffCollector(NodeState before, NodeState after) {
        this.before = before;
        this.after = after;
        this.results = new HashSet<String>();
    }

    @Override
    public Set<String> getResults(Filter filter) {
        if (!this.init) {
            this.collect(filter);
        }
        return this.results;
    }

    @Override
    public double getCost(Filter filter) {
        if (!this.init) {
            this.collect(filter);
        }
        if (this.results.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    public void collect(Filter filter) {
        DiffCollectorNodeStateDiff diff = new DiffCollectorNodeStateDiff(this, filter);
        this.after.compareAgainstBaseState(this.before, diff);
        this.results = new HashSet<String>(diff.getResults());
        this.init = true;
    }

    abstract boolean match(NodeState var1, Filter var2);

    protected boolean isUnique() {
        return false;
    }

    private static class DiffCollectorNodeStateDiff
    extends DefaultNodeStateDiff {
        private final BaseDiffCollector collector;
        private final Filter filter;
        private final Set<String> results;
        private final String path;

        DiffCollectorNodeStateDiff(BaseDiffCollector collector, Filter filter) {
            this(collector, filter, "", new HashSet<String>());
        }

        private DiffCollectorNodeStateDiff(BaseDiffCollector collector, Filter filter, String path, Set<String> results) {
            this.collector = collector;
            this.filter = filter;
            this.path = path;
            this.results = results;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            return this.childNodeChanged(name, EmptyNodeState.EMPTY_NODE, after);
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (NodeStateUtils.isHidden(name)) {
                return true;
            }
            return this.testNodeState(after, name) && after.compareAgainstBaseState(before, new DiffCollectorNodeStateDiff(this.collector, this.filter, PathUtils.concat(this.path, name), this.results));
        }

        private boolean testNodeState(NodeState nodeState, String currentPath) {
            if (this.collector.match(nodeState, this.filter)) {
                this.results.add(PathUtils.concat(this.path, currentPath));
                if (this.collector.isUnique()) {
                    return false;
                }
            }
            return true;
        }

        Set<String> getResults() {
            return this.results;
        }
    }
}

