/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.metrics;

import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.metrics.LatencyMetricsEvent;
import com.couchbase.client.core.metrics.AbstractMetricsCollector;
import com.couchbase.client.core.metrics.LatencyMetricsCollector;
import com.couchbase.client.core.metrics.LatencyMetricsCollectorConfig;
import com.couchbase.client.core.metrics.LatencyMetricsIdentifier;
import com.couchbase.client.deps.org.LatencyUtils.LatencyStats;
import com.couchbase.client.deps.org.LatencyUtils.PauseDetector;
import com.couchbase.client.deps.org.LatencyUtils.SimplePauseDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;

public abstract class AbstractLatencyMetricsCollector<I extends LatencyMetricsIdentifier, E extends LatencyMetricsEvent>
extends AbstractMetricsCollector
implements LatencyMetricsCollector<I> {
    private static final Object PAUSE_DETECTOR_LOCK = new Object();
    private static int pauseDetectorCount = 0;
    private static PauseDetector staticPauseDetector;
    private final PauseDetector pauseDetector;
    private final AtomicBoolean pauseDetectorHeld;
    private final Map<I, LatencyStats> latencyMetrics;
    private final LatencyMetricsCollectorConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PauseDetector acquirePauseDetector() {
        Object object = PAUSE_DETECTOR_LOCK;
        synchronized (object) {
            if (pauseDetectorCount++ == 0) {
                staticPauseDetector = new SimplePauseDetector(TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(10L), 3);
            }
            return staticPauseDetector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePauseDetector() {
        Object object = PAUSE_DETECTOR_LOCK;
        synchronized (object) {
            if (--pauseDetectorCount == 0) {
                staticPauseDetector.shutdown();
                staticPauseDetector = null;
            }
        }
    }

    protected AbstractLatencyMetricsCollector(EventBus eventBus, Scheduler scheduler, LatencyMetricsCollectorConfig config) {
        super(eventBus, scheduler, config);
        this.config = config;
        this.latencyMetrics = new ConcurrentHashMap<I, LatencyStats>();
        this.pauseDetector = AbstractLatencyMetricsCollector.acquirePauseDetector();
        this.pauseDetectorHeld = new AtomicBoolean(true);
    }

    protected abstract E generateLatencyMetricsEvent(Map<I, LatencyStats> var1);

    @Override
    protected CouchbaseEvent generateCouchbaseEvent() {
        return this.generateLatencyMetricsEvent(new HashMap<I, LatencyStats>(this.latencyMetrics));
    }

    @Override
    public void record(I identifier, long latency) {
        if (this.config.emitFrequency() <= 0L) {
            return;
        }
        LatencyStats metric = this.latencyMetrics.get(identifier);
        if (metric == null) {
            metric = LatencyStats.Builder.create().pauseDetector(this.pauseDetector).build();
            this.latencyMetrics.put(identifier, metric);
        }
        metric.recordLatency(latency);
    }

    @Override
    public boolean shutdown() {
        if (this.pauseDetectorHeld.compareAndSet(true, false)) {
            AbstractLatencyMetricsCollector.releasePauseDetector();
        }
        return super.shutdown();
    }

    @Override
    public LatencyMetricsCollectorConfig config() {
        return this.config;
    }

    protected void remove(I identifier) {
        this.latencyMetrics.remove(identifier);
    }
}

