/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.lock;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

public abstract class LockOperation<T>
extends SessionOperation<T> {
    protected final SessionDelegate session;
    private final NodeDelegate node;
    private final String path;

    protected LockOperation(SessionDelegate session, NodeDelegate node, String name) {
        super(name);
        this.session = session;
        this.path = null;
        this.node = node;
    }

    protected LockOperation(SessionContext context, String absPath, String name) throws PathNotFoundException {
        super(name);
        this.session = context.getSessionDelegate();
        this.path = context.getOakPathOrThrowNotFound(absPath);
        this.node = null;
    }

    @Override
    public boolean isRefresh() {
        return true;
    }

    @Override
    public T perform() throws RepositoryException {
        this.session.refresh(true);
        if (this.node != null) {
            return this.perform(this.node);
        }
        NodeDelegate node = this.session.getNode(this.path);
        if (node != null) {
            return this.perform(node);
        }
        throw new PathNotFoundException("Node " + this.path + " not found");
    }

    protected abstract T perform(NodeDelegate var1) throws RepositoryException;
}

