/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;

public class CustomObjectOutputStream
extends ObjectOutputStream {
    private FastStack callbacks = new FastStack(1);
    private FastStack customFields = new FastStack(1);
    private static final String DATA_HOLDER_KEY = CustomObjectOutputStream.class.getName();

    public static synchronized CustomObjectOutputStream getInstance(DataHolder whereFrom, StreamCallback callback) {
        try {
            CustomObjectOutputStream result = (CustomObjectOutputStream)whereFrom.get(DATA_HOLDER_KEY);
            if (result == null) {
                result = new CustomObjectOutputStream(callback);
                whereFrom.put(DATA_HOLDER_KEY, result);
            } else {
                result.pushCallback(callback);
            }
            return result;
        }
        catch (IOException e) {
            throw new ConversionException("Cannot create CustomObjectStream", e);
        }
    }

    public CustomObjectOutputStream(StreamCallback callback) throws IOException, SecurityException {
        this.callbacks.push(callback);
    }

    public void pushCallback(StreamCallback callback) {
        this.callbacks.push(callback);
    }

    public StreamCallback popCallback() {
        return (StreamCallback)this.callbacks.pop();
    }

    public StreamCallback peekCallback() {
        return (StreamCallback)this.callbacks.peek();
    }

    public void defaultWriteObject() throws IOException {
        this.peekCallback().defaultWriteObject();
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        this.peekCallback().writeToStream(obj);
    }

    public void writeBoolean(boolean val2) throws IOException {
        this.peekCallback().writeToStream(val2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void writeByte(int val2) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)val2));
    }

    public void writeInt(int val2) throws IOException {
        this.peekCallback().writeToStream(new Integer(val2));
    }

    public void writeChar(int val2) throws IOException {
        this.peekCallback().writeToStream(new Character((char)val2));
    }

    public void writeDouble(double val2) throws IOException {
        this.peekCallback().writeToStream(new Double(val2));
    }

    public void writeFloat(float val2) throws IOException {
        this.peekCallback().writeToStream(new Float(val2));
    }

    public void writeLong(long val2) throws IOException {
        this.peekCallback().writeToStream(new Long(val2));
    }

    public void writeShort(int val2) throws IOException {
        this.peekCallback().writeToStream(new Short((short)val2));
    }

    public void write(byte[] buf) throws IOException {
        this.peekCallback().writeToStream(buf);
    }

    public void writeChars(String str) throws IOException {
        this.peekCallback().writeToStream(str.toCharArray());
    }

    public void writeUTF(String str) throws IOException {
        this.peekCallback().writeToStream(str);
    }

    public void write(int val2) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)val2));
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] b = new byte[len];
        System.arraycopy(buf, off, b, 0, len);
        this.peekCallback().writeToStream(b);
    }

    public void flush() throws IOException {
        this.peekCallback().flush();
    }

    public void close() throws IOException {
        this.peekCallback().close();
    }

    public ObjectOutputStream.PutField putFields() {
        CustomPutField result = new CustomPutField();
        this.customFields.push(result);
        return result;
    }

    public void writeFields() throws IOException {
        CustomPutField customPutField = (CustomPutField)this.customFields.pop();
        this.peekCallback().writeFieldsToStream(customPutField.asMap());
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void useProtocolVersion(int version) {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(String str) {
        throw new UnsupportedOperationException();
    }

    public void writeUnshared(Object obj) {
        throw new UnsupportedOperationException();
    }

    private class CustomPutField
    extends ObjectOutputStream.PutField {
        private final Map fields = new OrderRetainingMap();

        private CustomPutField() {
        }

        public Map asMap() {
            return this.fields;
        }

        public void write(ObjectOutput out) throws IOException {
            CustomObjectOutputStream.this.peekCallback().writeToStream(this.asMap());
        }

        public void put(String name, Object val2) {
            this.fields.put(name, val2);
        }

        public void put(String name, byte val2) {
            this.put(name, new Byte(val2));
        }

        public void put(String name, char val2) {
            this.put(name, new Character(val2));
        }

        public void put(String name, double val2) {
            this.put(name, new Double(val2));
        }

        public void put(String name, float val2) {
            this.put(name, new Float(val2));
        }

        public void put(String name, int val2) {
            this.put(name, new Integer(val2));
        }

        public void put(String name, long val2) {
            this.put(name, new Long(val2));
        }

        public void put(String name, short val2) {
            this.put(name, new Short(val2));
        }

        public void put(String name, boolean val2) {
            this.put(name, val2 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static interface StreamCallback {
        public void writeToStream(Object var1) throws IOException;

        public void writeFieldsToStream(Map var1) throws IOException;

        public void defaultWriteObject() throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;
    }
}

