/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester;

import com.google.analytics.data.v1beta.BetaAnalyticsDataClient;
import com.google.analytics.data.v1beta.BetaAnalyticsDataSettings;
import com.google.analytics.data.v1beta.DateRange;
import com.google.analytics.data.v1beta.Dimension;
import com.google.analytics.data.v1beta.Metric;
import com.google.analytics.data.v1beta.Row;
import com.google.analytics.data.v1beta.RunReportRequest;
import com.google.analytics.data.v1beta.RunReportResponse;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.dataharvest.datamodel.AnalyticsReportCredentials;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.datamodel.VREAccessesReportRow;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.Utils;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VREAccessesHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(VREAccessesHarvester.class);
    private static final String SERVICE_ENDPOINT_CATEGORY = "OnlineService";
    private static final String SERVICE_ENDPOINT_NAME = "GA4AnalyticsDataService";
    private static final String AP_VIEWS_PROPERTY = "views";
    private static final String AP_CLIENT_ID = "client_id";
    private static final String AP_PRIVATEKEY_ID_PROPERTY = "private_key_id";
    private List<VREAccessesReportRow> vreAccesses;

    public VREAccessesHarvester(Date start, Date end) throws Exception {
        super(start, end);
        this.vreAccesses = VREAccessesHarvester.getAllAccesses(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        String context = Utils.getCurrentContext();
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        int measure = 0;
        ScopeBean scopeBean = new ScopeBean(context);
        String lowerCasedContext = scopeBean.name().toLowerCase();
        String case1 = lowerCasedContext + "/";
        String case2 = lowerCasedContext + "?";
        for (VREAccessesReportRow row : this.vreAccesses) {
            String pagePath = row.getPagePath();
            if (pagePath.contains("_redirect=/group") || pagePath.contains("workspace")) continue;
            if (pagePath.endsWith(lowerCasedContext)) {
                logger.debug("Matched endsWith({}) : {}", (Object)lowerCasedContext, (Object)pagePath);
                measure += row.getVisitNumber();
                continue;
            }
            if (!pagePath.contains(case1) && !pagePath.contains(case2)) continue;
            logger.debug("Matched contains({}) || contains({}) : {}", new Object[]{case1, case2, pagePath});
            measure += row.getVisitNumber();
        }
        ScopeDescriptor scopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor(context);
        AccountingRecord ar = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.ACCESSES), Long.valueOf(measure));
        logger.debug("{} : {}", (Object)ar.getDimension().getId(), (Object)ar.getMeasure());
        accountingRecords.add(ar);
        return accountingRecords;
    }

    private static List<VREAccessesReportRow> getAllAccesses(Date start, Date end) throws Exception {
        DateRange.Builder dateRangeBuilder = VREAccessesHarvester.getDateRangeBuilderForAnalytics(start, end);
        logger.debug("Getting accesses in this time range {}", (Object)dateRangeBuilder.toString());
        AnalyticsReportCredentials credentialsFromD4S = VREAccessesHarvester.getAuthorisedApplicationInfoFromIs();
        logger.debug("Getting credentials credentialsFromD4S");
        BetaAnalyticsDataSettings serviceSettings = VREAccessesHarvester.initializeAnalyticsReporting(credentialsFromD4S);
        logger.debug("initializeAnalyticsReporting service settings");
        HashMap<String, List<RunReportResponse>> responses = VREAccessesHarvester.getReportResponses(serviceSettings, credentialsFromD4S.getViewIds(), dateRangeBuilder);
        ArrayList<VREAccessesReportRow> totalAccesses = new ArrayList<VREAccessesReportRow>();
        for (String view : responses.keySet()) {
            List<VREAccessesReportRow> viewReport = VREAccessesHarvester.parseResponse(view, responses.get(view));
            logger.debug("Got {} entries from view id={}", (Object)viewReport.size(), (Object)view);
            totalAccesses.addAll(viewReport);
        }
        logger.debug("Merged in {} total entries from all views", (Object)totalAccesses.size());
        return totalAccesses;
    }

    private static BetaAnalyticsDataSettings initializeAnalyticsReporting(AnalyticsReportCredentials cred) throws IOException {
        return ((BetaAnalyticsDataSettings.Builder)BetaAnalyticsDataSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)ServiceAccountCredentials.fromPkcs8((String)cred.getClientId(), (String)cred.getClientEmail(), (String)cred.getPrivateKeyPem(), (String)cred.getPrivateKeyId(), null)))).build();
    }

    private static HashMap<String, List<RunReportResponse>> getReportResponses(BetaAnalyticsDataSettings betaAnalyticsDataSettings, List<String> viewIDs, DateRange.Builder dateRangeBuilder) throws IOException {
        HashMap<String, List<RunReportResponse>> reports = new HashMap<String, List<RunReportResponse>>();
        try (BetaAnalyticsDataClient analyticsData = BetaAnalyticsDataClient.create((BetaAnalyticsDataSettings)betaAnalyticsDataSettings);){
            for (String propertyId : viewIDs) {
                ArrayList<RunReportResponse> gReportResponses = new ArrayList<RunReportResponse>();
                logger.debug("Getting data from Analytics Data API for propertyId: " + propertyId);
                RunReportRequest request = RunReportRequest.newBuilder().setProperty("properties/" + propertyId).addDimensions(Dimension.newBuilder().setName("pagePath")).addMetrics(Metric.newBuilder().setName("screenPageViews")).addDateRanges(dateRangeBuilder).build();
                RunReportResponse response = analyticsData.runReport(request);
                gReportResponses.add(response);
                reports.put(propertyId, gReportResponses);
            }
        }
        return reports;
    }

    private static List<VREAccessesReportRow> parseResponse(String viewId, List<RunReportResponse> responses) {
        logger.debug("parsing Response for propertyID=" + viewId);
        ArrayList<VREAccessesReportRow> toReturn = new ArrayList<VREAccessesReportRow>();
        for (RunReportResponse response : responses) {
            for (Row row : response.getRowsList()) {
                String dimension = row.getDimensionValues(0).getValue();
                String metric = row.getMetricValues(0).getValue();
                VREAccessesReportRow var = new VREAccessesReportRow();
                boolean validEntry = false;
                String pagePath = dimension;
                if (pagePath.startsWith("/group") || pagePath.startsWith("/web")) {
                    var.setPagePath(dimension);
                    validEntry = true;
                }
                if (!validEntry) continue;
                var.setVisitNumber(Integer.parseInt(metric));
                toReturn.add(var);
            }
        }
        return toReturn;
    }

    private static List<ServiceEndpoint> getAnalyticsReportingConfigurationFromIS(String infrastructureScope) throws Exception {
        String scope = infrastructureScope;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'OnlineService'");
        query.addCondition("$resource/Profile/Name/text() eq 'GA4AnalyticsDataService'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }

    private static AnalyticsReportCredentials getAuthorisedApplicationInfoFromIs() throws Exception {
        AnalyticsReportCredentials reportCredentials = new AnalyticsReportCredentials();
        String context = Utils.getCurrentContext();
        try {
            List<ServiceEndpoint> list = VREAccessesHarvester.getAnalyticsReportingConfigurationFromIS(context);
            if (list.size() > 1) {
                logger.error("Too many Service Endpoints having name GA4AnalyticsDataService in this scope having Category OnlineService");
            } else if (list.size() == 0) {
                logger.warn("There is no Service Endpoint having name GA4AnalyticsDataService and Category OnlineService in this context: " + context);
            } else {
                for (ServiceEndpoint res : list) {
                    Group apGroup = res.profile().accessPoints();
                    ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
                    ServiceEndpoint.AccessPoint found = accessPoints[0];
                    reportCredentials.setClientEmail(found.username());
                    String decryptedPrivateKey = StringEncrypter.getEncrypter().decrypt(found.password());
                    reportCredentials.setPrivateKeyPem(decryptedPrivateKey.trim());
                    for (ServiceEndpoint.Property prop : found.properties()) {
                        String decryptedValue;
                        if (prop.name().compareTo(AP_VIEWS_PROPERTY) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            String[] views = decryptedValue.split(";");
                            reportCredentials.setViewIds(Arrays.asList(views));
                        }
                        if (prop.name().compareTo(AP_CLIENT_ID) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            reportCredentials.setClientId(decryptedValue);
                        }
                        if (prop.name().compareTo(AP_PRIVATEKEY_ID_PROPERTY) != 0) continue;
                        decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                        reportCredentials.setPrivateKeyId(decryptedValue);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return reportCredentials;
    }

    private static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static DateRange.Builder getDateRangeBuilderForAnalytics(Date start, Date end) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String startDate = VREAccessesHarvester.asLocalDate(start).format(formatter);
        String endDate = VREAccessesHarvester.asLocalDate(end).format(formatter);
        DateRange.Builder dateRangeBuilder = DateRange.newBuilder().setStartDate(startDate).setEndDate(endDate);
        return dateRangeBuilder;
    }
}

