/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester.sobigdata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.internal.Dimension;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.DateUtils;
import org.gcube.dataharvest.utils.Utils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagMeMethodInvocationHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(TagMeMethodInvocationHarvester.class);
    public static final String SWAT = "SWAT";
    public static final String TAGME = "TagMe";
    public static final String WAT = "WAT";
    public static String[] SERVICE_NAMES = new String[]{"SWAT", "TagMe", "WAT"};

    public TagMeMethodInvocationHarvester(Date start, Date end) throws Exception {
        super(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        AccountingPersistenceQuery accountingPersistenceQuery = AccountingPersistenceQueryFactory.getInstance();
        TemporalConstraint temporalConstraint = new TemporalConstraint(this.start.getTime(), this.end.getTime(), TemporalConstraint.AggregationMode.MONTHLY);
        ArrayList<String> contexts = new ArrayList<String>();
        String context = Utils.getCurrentContext();
        contexts.add(context);
        long numberOfInvocation = 0L;
        ArrayList<Filter> tagMe1Filters = new ArrayList<Filter>();
        tagMe1Filters.add(new Filter("serviceName", TAGME));
        tagMe1Filters.add(new Filter("calledMethod", "tag"));
        ArrayList<Filter> tagMe2Filters = new ArrayList<Filter>();
        tagMe2Filters.add(new Filter("serviceName", TAGME));
        tagMe2Filters.add(new Filter("calledMethod", "/tag"));
        ArrayList<Filter> watFilters = new ArrayList<Filter>();
        watFilters.add(new Filter("serviceName", WAT));
        ArrayList<Filter> swatFilters = new ArrayList<Filter>();
        swatFilters.add(new Filter("serviceName", SWAT));
        ArrayList<ArrayList<Filter>> allfilters = new ArrayList<ArrayList<Filter>>();
        allfilters.add(tagMe1Filters);
        allfilters.add(tagMe2Filters);
        allfilters.add(watFilters);
        allfilters.add(swatFilters);
        for (List list : allfilters) {
            SortedMap result = accountingPersistenceQuery.getContextTimeSeries(AggregatedServiceUsageRecord.class, temporalConstraint, list, contexts, true);
            if (result != null) {
                for (Filter filter : result.keySet()) {
                    SortedMap infoMap = (SortedMap)result.get(filter);
                    Calendar calendar = DateUtils.dateToCalendar(this.start);
                    Info info = (Info)infoMap.get(calendar);
                    logger.debug("{} : {} : {}", new Object[]{list, DateUtils.format(calendar), info});
                    JSONObject jsonObject = info.getValue();
                    long got = jsonObject.getLong("operationCount");
                    numberOfInvocation += got;
                }
                continue;
            }
            logger.error("No data found in {} for filters {}.", (Object)context, (Object)list);
        }
        ScopeDescriptor scopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor(context);
        Dimension dimension = this.getDimension(HarvestedDataKey.METHOD_INVOCATIONS);
        AccountingRecord ar = new AccountingRecord(scopeDescriptor, this.instant, dimension, Long.valueOf(numberOfInvocation));
        logger.debug("{} : {}", (Object)ar.getDimension().getId(), (Object)ar.getMeasure());
        accountingRecords.add(ar);
        return accountingRecords;
    }
}

