/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester;

import com.google.analytics.data.v1beta.BetaAnalyticsDataClient;
import com.google.analytics.data.v1beta.BetaAnalyticsDataSettings;
import com.google.analytics.data.v1beta.DateRange;
import com.google.analytics.data.v1beta.Dimension;
import com.google.analytics.data.v1beta.Metric;
import com.google.analytics.data.v1beta.Row;
import com.google.analytics.data.v1beta.RunReportRequest;
import com.google.analytics.data.v1beta.RunReportResponse;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.IOException;
import java.io.StringReader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.dataharvest.datamodel.AnalyticsReportCredentials;
import org.gcube.dataharvest.datamodel.CoreServiceAccessesReportRow;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.Utils;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CoreServicesAccessesHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(CoreServicesAccessesHarvester.class);
    private static final String MAPPING_RESOURCE_CATEGORY = "BigGAnalyticsMapping";
    private static final String SERVICE_ENDPOINT_CATEGORY = "OnlineService";
    private static final String SERVICE_ENDPOINT_NAME = "GA4AnalyticsDataService";
    private static final String AP_VIEWS_PROPERTY = "views";
    private static final String AP_CLIENT_ID = "client_id";
    private static final String AP_PRIVATEKEY_ID_PROPERTY = "private_key_id";
    private static final String PAGE_WORKSPACE_ACCESSES = "/workspace";
    private static final String PAGE_MESSAGES_ACCESSES = "/messages";
    private static final String PAGE_PROFILE_ACCESSES = "/profile";
    private static final String PAGE_NOTIFICATION_ACCESSES = "/notifications";
    private HashMap<String, List<CoreServiceAccessesReportRow>> coreServicesAccesses;

    public CoreServicesAccessesHarvester(Date start, Date end) throws Exception {
        super(start, end);
        this.coreServicesAccesses = CoreServicesAccessesHarvester.getAllAccesses(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        for (String dashboardContext : this.coreServicesAccesses.keySet()) {
            int workspaceAccesses = 0;
            int messagesAccesses = 0;
            int notificationsAccesses = 0;
            int profileAccesses = 0;
            logger.debug("{};", (Object)dashboardContext);
            for (CoreServiceAccessesReportRow row : this.coreServicesAccesses.get(dashboardContext)) {
                switch (row.getKey()) {
                    case WORKSPACE_ACCESSES: {
                        workspaceAccesses += row.getVisitNumber();
                        break;
                    }
                    case MESSAGES_ACCESSES: {
                        messagesAccesses += row.getVisitNumber();
                        break;
                    }
                    case NOTIFICATIONS_ACCESSES: {
                        notificationsAccesses += row.getVisitNumber();
                        break;
                    }
                    case PROFILE_ACCESSES: {
                        profileAccesses += row.getVisitNumber();
                        break;
                    }
                }
            }
            ScopeDescriptor scopeDescriptor = new ScopeDescriptor();
            ScopeBean scopeBean = new ScopeBean(dashboardContext);
            scopeDescriptor.setId(dashboardContext);
            scopeDescriptor.setName(scopeBean.name());
            AccountingRecord ar1 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.WORKSPACE_ACCESSES), Long.valueOf(workspaceAccesses));
            AccountingRecord ar2 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.MESSAGES_ACCESSES), Long.valueOf(messagesAccesses));
            AccountingRecord ar3 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.NOTIFICATIONS_ACCESSES), Long.valueOf(notificationsAccesses));
            AccountingRecord ar4 = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.PROFILE_ACCESSES), Long.valueOf(profileAccesses));
            logger.debug("{};{}", (Object)ar1.getDimension().getId(), (Object)ar1.getMeasure());
            accountingRecords.add(ar1);
            logger.debug("{};{}", (Object)ar2.getDimension().getId(), (Object)ar2.getMeasure());
            accountingRecords.add(ar2);
            logger.debug("{};{}", (Object)ar3.getDimension().getId(), (Object)ar3.getMeasure());
            accountingRecords.add(ar3);
            logger.debug("{};{}", (Object)ar4.getDimension().getId(), (Object)ar4.getMeasure());
            accountingRecords.add(ar4);
        }
        logger.debug("Returning  {} accountingRecords ", (Object)accountingRecords.size());
        return accountingRecords;
    }

    private static HashMap<String, List<CoreServiceAccessesReportRow>> getAllAccesses(Date start, Date end) throws Exception {
        DateRange.Builder dateRangeBuilder = CoreServicesAccessesHarvester.getDateRangeBuilderForAnalytics(start, end);
        logger.trace("Getting core services accesses in this time range {}", (Object)dateRangeBuilder.toString());
        AnalyticsReportCredentials credentialsFromD4S = CoreServicesAccessesHarvester.getAuthorisedApplicationInfoFromIs();
        logger.trace("gotten credentialsFromD4S id = {}", (Object)credentialsFromD4S.getClientId());
        BetaAnalyticsDataSettings serviceSettings = CoreServicesAccessesHarvester.initializeAnalyticsReporting(credentialsFromD4S);
        logger.trace("gotten credentialsFromD4S viewIds= {}", (Object)credentialsFromD4S.getViewIds().toString());
        HashMap<String, List<RunReportResponse>> responses = CoreServicesAccessesHarvester.getReportResponses(serviceSettings, credentialsFromD4S.getViewIds(), dateRangeBuilder);
        HashMap<String, List<CoreServiceAccessesReportRow>> toReturn = new HashMap<String, List<CoreServiceAccessesReportRow>>();
        int i = 1;
        for (String view : responses.keySet()) {
            String dashboardContext = CoreServicesAccessesHarvester.getAccountingDashboardContextGivenGAViewID(view);
            if (dashboardContext != null) {
                logger.trace("\n ({}) ***  Parsing responses for this Gateway view, which corresponds to Dashboard Context: {} \n", (Object)i, (Object)dashboardContext);
                List<CoreServiceAccessesReportRow> viewReport = CoreServicesAccessesHarvester.parseResponse(view, responses.get(view), dashboardContext);
                logger.trace("Got {} entries from view id={}", (Object)viewReport.size(), (Object)view);
                toReturn.put(dashboardContext, viewReport);
            } else {
                logger.warn("Got entries from view id={} but cannot find Dashboard Context correspondance, I think you need to update the Generic Resource of the Mappings", (Object)view);
            }
            ++i;
        }
        return toReturn;
    }

    private static BetaAnalyticsDataSettings initializeAnalyticsReporting(AnalyticsReportCredentials cred) throws IOException {
        return ((BetaAnalyticsDataSettings.Builder)BetaAnalyticsDataSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)ServiceAccountCredentials.fromPkcs8((String)cred.getClientId(), (String)cred.getClientEmail(), (String)cred.getPrivateKeyPem(), (String)cred.getPrivateKeyId(), null)))).build();
    }

    private static HashMap<String, List<RunReportResponse>> getReportResponses(BetaAnalyticsDataSettings betaAnalyticsDataSettings, List<String> viewIDs, DateRange.Builder dateRangeBuilder) throws IOException {
        HashMap<String, List<RunReportResponse>> reports = new HashMap<String, List<RunReportResponse>>();
        try (BetaAnalyticsDataClient analyticsData = BetaAnalyticsDataClient.create((BetaAnalyticsDataSettings)betaAnalyticsDataSettings);){
            for (String propertyId : viewIDs) {
                ArrayList<RunReportResponse> gReportResponses = new ArrayList<RunReportResponse>();
                logger.debug("Getting data from Analytics Data API for propertyId: " + propertyId);
                RunReportRequest request = RunReportRequest.newBuilder().setProperty("properties/" + propertyId).addDimensions(Dimension.newBuilder().setName("pagePath")).addMetrics(Metric.newBuilder().setName("screenPageViews")).addDateRanges(dateRangeBuilder).build();
                RunReportResponse response = analyticsData.runReport(request);
                gReportResponses.add(response);
                reports.put(propertyId, gReportResponses);
            }
        }
        return reports;
    }

    private static List<CoreServiceAccessesReportRow> parseResponse(String viewId, List<RunReportResponse> responses, String dashboardContext) {
        logger.debug("parsing Response for propertyID=" + viewId);
        ArrayList<CoreServiceAccessesReportRow> toReturn = new ArrayList<CoreServiceAccessesReportRow>();
        for (RunReportResponse response : responses) {
            for (Row row : response.getRowsList()) {
                String dimension = row.getDimensionValues(0).getValue();
                String metric = row.getMetricValues(0).getValue();
                CoreServiceAccessesReportRow var = new CoreServiceAccessesReportRow();
                boolean validEntry = false;
                String pagePath = dimension;
                logger.trace("parsing pagepath {}: value: {}", (Object)pagePath, (Object)Integer.parseInt(metric));
                if (!pagePath.contains("_redirect=/group")) {
                    if (pagePath.contains(PAGE_WORKSPACE_ACCESSES)) {
                        var.setKey(HarvestedDataKey.WORKSPACE_ACCESSES);
                        logger.trace("**matched " + pagePath);
                        validEntry = true;
                    } else if (pagePath.contains(PAGE_MESSAGES_ACCESSES)) {
                        var.setKey(HarvestedDataKey.MESSAGES_ACCESSES);
                        logger.trace("**matched " + pagePath);
                        validEntry = true;
                    } else if (pagePath.contains(PAGE_PROFILE_ACCESSES)) {
                        var.setKey(HarvestedDataKey.PROFILE_ACCESSES);
                        logger.trace("**matched " + pagePath);
                        validEntry = true;
                    } else if (pagePath.contains(PAGE_NOTIFICATION_ACCESSES)) {
                        var.setKey(HarvestedDataKey.NOTIFICATIONS_ACCESSES);
                        logger.trace("**matched " + pagePath);
                        validEntry = true;
                    }
                }
                if (!validEntry) continue;
                var.setDashboardContext(dashboardContext);
                var.setPagePath(dimension);
                var.setVisitNumber(Integer.parseInt(metric));
                toReturn.add(var);
            }
        }
        return toReturn;
    }

    private static List<ServiceEndpoint> getAnalyticsReportingConfigurationFromIS(String infrastructureScope) throws Exception {
        String scope = infrastructureScope;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'OnlineService'");
        query.addCondition("$resource/Profile/Name/text() eq 'GA4AnalyticsDataService'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }

    private static String getAccountingDashboardContextGivenGAViewID(String viewID) throws ObjectNotFound, Exception {
        String toReturn = null;
        String context = Utils.getCurrentContext();
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(context);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'BigGAnalyticsMapping'");
        query.addCondition("$resource/Profile/Body/Property/viewID/text() eq '" + viewID + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List list = client.submit((Query)query);
        if (list.size() > 1) {
            logger.error("Too many Generic Resources having GA viewID " + viewID + " in this scope having SecondaryType " + MAPPING_RESOURCE_CATEGORY);
        } else if (list.size() == 0) {
            logger.warn("There is no Generic Resources having GA viewID " + viewID + " and SecondaryType " + MAPPING_RESOURCE_CATEGORY + " in this context: " + context);
        } else {
            GenericResource found = (GenericResource)list.get(0);
            String elem = "<body>" + found.profile().bodyAsString() + "</body>";
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
            XPathHelper helper = new XPathHelper((Node)node);
            List currValue = helper.evaluate("//Property/viewID/text()");
            if (currValue != null && currValue.size() > 0) {
                List contexts = currValue;
                for (int i = 0; i < contexts.size(); ++i) {
                    if (((String)currValue.get(i)).trim().compareTo(viewID) != 0) continue;
                    toReturn = (String)helper.evaluate("//Property/DashboardContext/text()").get(i);
                    break;
                }
            }
            logger.debug("Found DashboardContext for viewId {} : {} ", (Object)viewID, toReturn);
        }
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }

    private static AnalyticsReportCredentials getAuthorisedApplicationInfoFromIs() throws Exception {
        AnalyticsReportCredentials reportCredentials = new AnalyticsReportCredentials();
        String context = Utils.getCurrentContext();
        try {
            List<ServiceEndpoint> list = CoreServicesAccessesHarvester.getAnalyticsReportingConfigurationFromIS(context);
            if (list.size() > 1) {
                logger.error("Too many Service Endpoints having name GA4AnalyticsDataService in this scope having Category OnlineService");
            } else if (list.size() == 0) {
                logger.warn("There is no Service Endpoint having name GA4AnalyticsDataService and Category OnlineService in this context: " + context);
            } else {
                for (ServiceEndpoint res : list) {
                    Group apGroup = res.profile().accessPoints();
                    ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
                    ServiceEndpoint.AccessPoint found = accessPoints[0];
                    reportCredentials.setClientEmail(found.username());
                    String decryptedPrivateKey = StringEncrypter.getEncrypter().decrypt(found.password());
                    reportCredentials.setPrivateKeyPem(decryptedPrivateKey.trim());
                    for (ServiceEndpoint.Property prop : found.properties()) {
                        String decryptedValue;
                        if (prop.name().compareTo(AP_VIEWS_PROPERTY) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            String[] views = decryptedValue.split(";");
                            reportCredentials.setViewIds(Arrays.asList(views));
                        }
                        if (prop.name().compareTo(AP_CLIENT_ID) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            reportCredentials.setClientId(decryptedValue);
                        }
                        if (prop.name().compareTo(AP_PRIVATEKEY_ID_PROPERTY) != 0) continue;
                        decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                        reportCredentials.setPrivateKeyId(decryptedValue);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return reportCredentials;
    }

    private static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static DateRange.Builder getDateRangeBuilderForAnalytics(Date start, Date end) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String startDate = CoreServicesAccessesHarvester.asLocalDate(start).format(formatter);
        String endDate = CoreServicesAccessesHarvester.asLocalDate(end).format(formatter);
        DateRange.Builder dateRangeBuilder = DateRange.newBuilder().setStartDate(startDate).setEndDate(endDate);
        return dateRangeBuilder;
    }
}

