/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.api.services.analyticsreporting.v4.AnalyticsReporting;
import com.google.api.services.analyticsreporting.v4.AnalyticsReportingScopes;
import com.google.api.services.analyticsreporting.v4.model.DateRange;
import com.google.api.services.analyticsreporting.v4.model.DateRangeValues;
import com.google.api.services.analyticsreporting.v4.model.Dimension;
import com.google.api.services.analyticsreporting.v4.model.GetReportsRequest;
import com.google.api.services.analyticsreporting.v4.model.GetReportsResponse;
import com.google.api.services.analyticsreporting.v4.model.Metric;
import com.google.api.services.analyticsreporting.v4.model.Report;
import com.google.api.services.analyticsreporting.v4.model.ReportRequest;
import com.google.api.services.analyticsreporting.v4.model.ReportRow;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.dataharvest.datamodel.AnalyticsReportCredentials;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.datamodel.VREAccessesReportRow;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.Utils;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RStudioAccessesHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(RStudioAccessesHarvester.class);
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final String SERVICE_ENDPOINT_CATEGORY = "OnlineService";
    private static final String SERVICE_ENDPOINT_NAME = "BigGAnalyticsReportService";
    private static final String AP_VIEWS_PROPERTY = "views";
    private static final String AP_CLIENT_PROPERTY = "clientId";
    private static final String AP_PRIVATEKEY_PROPERTY = "privateKeyId";
    private static final String APPLICATION_NAME = "Analytics Reporting";
    private List<VREAccessesReportRow> vreAccesses;

    public RStudioAccessesHarvester(Date start, Date end) throws Exception {
        super(start, end);
        logger.debug("RStudioAccessHArvester: {}, {}", (Object)start, (Object)end);
        this.vreAccesses = RStudioAccessesHarvester.getAllAccesses(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        String context = Utils.getCurrentContext();
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        int measure = 0;
        ScopeBean scopeBean = new ScopeBean(context);
        String lowerCasedContext = scopeBean.name().toLowerCase();
        logger.debug("RStudioAccessHArvester lowerCasedContext: {}", (Object)lowerCasedContext);
        for (VREAccessesReportRow row : this.vreAccesses) {
            String pagePath = row.getPagePath().toLowerCase();
            if (pagePath == null || pagePath.isEmpty() || !pagePath.contains(lowerCasedContext) || pagePath.contains("catalogue") || !pagePath.contains("rstudio") && !pagePath.contains("r-studio")) continue;
            logger.trace("Matched rstudio or rstudio ({}) : {}", (Object)lowerCasedContext, (Object)pagePath);
            measure += row.getVisitNumber();
        }
        ScopeDescriptor scopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor();
        if (measure > 0) {
            AccountingRecord ar = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.RSTUDIO_ACCESSES), Long.valueOf(measure));
            logger.debug("{} : {}", (Object)ar.getDimension().getId(), (Object)ar.getMeasure());
            accountingRecords.add(ar);
        }
        return accountingRecords;
    }

    private static List<VREAccessesReportRow> getAllAccesses(Date start, Date end) throws Exception {
        DateRange dateRange = RStudioAccessesHarvester.getDateRangeForAnalytics(start, end);
        logger.trace("Getting accesses in this time range {}", (Object)dateRange.toPrettyString());
        AnalyticsReportCredentials credentialsFromD4S = RStudioAccessesHarvester.getAuthorisedApplicationInfoFromIs();
        AnalyticsReporting service = RStudioAccessesHarvester.initializeAnalyticsReporting(credentialsFromD4S);
        HashMap<String, List<GetReportsResponse>> responses = RStudioAccessesHarvester.getReportResponses(service, credentialsFromD4S.getViewIds(), dateRange);
        ArrayList<VREAccessesReportRow> totalAccesses = new ArrayList<VREAccessesReportRow>();
        for (String view : responses.keySet()) {
            List<VREAccessesReportRow> viewReport = RStudioAccessesHarvester.parseResponse(view, responses.get(view));
            logger.trace("Got {} entries from view id={}", (Object)viewReport.size(), (Object)view);
            totalAccesses.addAll(viewReport);
        }
        logger.trace("Merged in {} total entries from all views", (Object)totalAccesses.size());
        return totalAccesses;
    }

    private static AnalyticsReporting initializeAnalyticsReporting(AnalyticsReportCredentials cred) throws GeneralSecurityException, IOException {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        GoogleCredential credential = RStudioAccessesHarvester.fromD4SServiceEndpoint(cred).createScoped((Collection)AnalyticsReportingScopes.all());
        return new AnalyticsReporting.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
    }

    private static HashMap<String, List<GetReportsResponse>> getReportResponses(AnalyticsReporting service, List<String> viewIDs, DateRange dateRange) throws IOException {
        HashMap<String, List<GetReportsResponse>> reports = new HashMap<String, List<GetReportsResponse>>();
        Metric sessions = new Metric().setExpression("ga:pageviews").setAlias("pages");
        Dimension pageTitle = new Dimension().setName("ga:pagePath");
        for (String view : viewIDs) {
            ArrayList<GetReportsResponse> gReportResponses = new ArrayList<GetReportsResponse>();
            logger.info("Getting data from Google Analytics for viewid: " + view);
            boolean iterateMorePages = true;
            String nextPageToken = null;
            while (iterateMorePages) {
                ReportRequest request = new ReportRequest().setViewId(view.trim()).setDateRanges(Arrays.asList(dateRange)).setMetrics(Arrays.asList(sessions)).setDimensions(Arrays.asList(pageTitle));
                request.setPageSize(Integer.valueOf(1000));
                request.setPageToken(nextPageToken);
                ArrayList<ReportRequest> requests = new ArrayList<ReportRequest>();
                requests.add(request);
                GetReportsRequest getReport = new GetReportsRequest().setReportRequests(requests);
                GetReportsResponse response = (GetReportsResponse)service.reports().batchGet(getReport).execute();
                nextPageToken = ((Report)response.getReports().get(0)).getNextPageToken();
                iterateMorePages = nextPageToken != null;
                logger.debug("got nextPageToken: " + nextPageToken);
                gReportResponses.add(response);
            }
            reports.put(view, gReportResponses);
        }
        return reports;
    }

    private static List<VREAccessesReportRow> parseResponse(String viewId, List<GetReportsResponse> responses) {
        logger.debug("parsing Response for " + viewId);
        ArrayList<VREAccessesReportRow> toReturn = new ArrayList<VREAccessesReportRow>();
        for (GetReportsResponse response : responses) {
            for (Report report : response.getReports()) {
                List rows = report.getData().getRows();
                if (rows == null) {
                    logger.warn("No data found for " + viewId);
                    continue;
                }
                for (ReportRow row : rows) {
                    String dimension = (String)row.getDimensions().get(0);
                    DateRangeValues metric = (DateRangeValues)row.getMetrics().get(0);
                    VREAccessesReportRow var = new VREAccessesReportRow();
                    boolean validEntry = false;
                    String pagePath = dimension;
                    if (pagePath.startsWith("/group") || pagePath.startsWith("/web")) {
                        var.setPagePath(dimension);
                        validEntry = true;
                    }
                    if (!validEntry) continue;
                    var.setVisitNumber(Integer.parseInt((String)metric.getValues().get(0)));
                    toReturn.add(var);
                }
            }
        }
        return toReturn;
    }

    private static GoogleCredential fromD4SServiceEndpoint(AnalyticsReportCredentials cred) throws IOException {
        String clientId = cred.getClientId();
        String clientEmail = cred.getClientEmail();
        String privateKeyPem = cred.getPrivateKeyPem();
        String privateKeyId = cred.getPrivateKeyId();
        String tokenUri = cred.getTokenUri();
        String projectId = cred.getProjectId();
        if (clientId == null || clientEmail == null || privateKeyPem == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from stream, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        PrivateKey privateKey = RStudioAccessesHarvester.privateKeyFromPkcs8(privateKeyPem);
        List emptyScopes = Collections.emptyList();
        GoogleCredential.Builder credentialBuilder = new GoogleCredential.Builder().setTransport(com.google.api.client.googleapis.util.Utils.getDefaultTransport()).setJsonFactory(com.google.api.client.googleapis.util.Utils.getDefaultJsonFactory()).setServiceAccountId(clientEmail).setServiceAccountScopes(emptyScopes).setServiceAccountPrivateKey(privateKey).setServiceAccountPrivateKeyId(privateKeyId);
        if (tokenUri != null) {
            credentialBuilder.setTokenServerEncodedUrl(tokenUri);
        }
        if (projectId != null) {
            credentialBuilder.setServiceAccountProjectId(projectId);
        }
        return credentialBuilder.build();
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        GeneralSecurityException unexpectedException = null;
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException exception) {
            unexpectedException = exception;
        }
        catch (InvalidKeySpecException exception) {
            unexpectedException = exception;
        }
        throw new IOException("Unexpected exception reading PKCS data", unexpectedException);
    }

    private static List<ServiceEndpoint> getAnalyticsReportingConfigurationFromIS(String infrastructureScope) throws Exception {
        String scope = infrastructureScope;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'OnlineService'");
        query.addCondition("$resource/Profile/Name/text() eq 'BigGAnalyticsReportService'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }

    private static AnalyticsReportCredentials getAuthorisedApplicationInfoFromIs() throws Exception {
        AnalyticsReportCredentials reportCredentials = new AnalyticsReportCredentials();
        String context = Utils.getCurrentContext();
        try {
            List<ServiceEndpoint> list = RStudioAccessesHarvester.getAnalyticsReportingConfigurationFromIS(context);
            if (list.size() > 1) {
                logger.error("Too many Service Endpoints having name BigGAnalyticsReportService in this scope having Category OnlineService");
            } else if (list.size() == 0) {
                logger.warn("There is no Service Endpoint having name BigGAnalyticsReportService and Category OnlineService in this context: " + context);
            } else {
                for (ServiceEndpoint res : list) {
                    reportCredentials.setTokenUri(res.profile().runtime().hostedOn());
                    Group apGroup = res.profile().accessPoints();
                    ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
                    ServiceEndpoint.AccessPoint found = accessPoints[0];
                    reportCredentials.setClientEmail(found.address());
                    reportCredentials.setProjectId(found.username());
                    reportCredentials.setPrivateKeyPem(StringEncrypter.getEncrypter().decrypt(found.password()));
                    for (ServiceEndpoint.Property prop : found.properties()) {
                        String decryptedValue;
                        if (prop.name().compareTo(AP_VIEWS_PROPERTY) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            String[] views = decryptedValue.split(";");
                            reportCredentials.setViewIds(Arrays.asList(views));
                        }
                        if (prop.name().compareTo(AP_CLIENT_PROPERTY) == 0) {
                            decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                            reportCredentials.setClientId(decryptedValue);
                        }
                        if (prop.name().compareTo(AP_PRIVATEKEY_PROPERTY) != 0) continue;
                        decryptedValue = StringEncrypter.getEncrypter().decrypt(prop.value());
                        reportCredentials.setPrivateKeyId(decryptedValue);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return reportCredentials;
    }

    private static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static DateRange getDateRangeForAnalytics(Date start, Date end) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String startDate = RStudioAccessesHarvester.asLocalDate(start).format(formatter);
        String endDate = RStudioAccessesHarvester.asLocalDate(end).format(formatter);
        DateRange dateRange = new DateRange();
        dateRange.setStartDate(startDate);
        dateRange.setEndDate(endDate);
        return dateRange;
    }
}

