package org.gcube.dataharvest;

import java.util.HashMap;
import java.util.Map;

import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Eric Perrone (ISTI - CNR)
 * @author Luca Frosini (ISTI - CNR)
 */
public class AccountingDashboardHarvesterPluginDeclaration implements PluginDeclaration {
	
	private static Logger logger = LoggerFactory.getLogger(AccountingDashboardHarvesterPluginDeclaration.class);
	
	public static final String NAME = "AccountingDashboardHarvester";
	public static final String DESCRIPTION = "Data Harvester for Accounting Dashboard";
	public static final String VERSION = "1.4.0";

	/**{@inheritDoc}*/
	@Override
	public void init() {
		logger.debug(String.format("%s initialized", AccountingDashboardHarvesterPlugin.class.getSimpleName()));
	}
	
	/**{@inheritDoc}*/
	@Override
	public String getName() {
		return NAME;
	}
	
	/**{@inheritDoc}*/
	@Override
	public String getDescription() {
		return DESCRIPTION;
	}

	/**{@inheritDoc}*/
	@Override
	public String getVersion() {
		return VERSION;
	}
	
	/**{@inheritDoc}*/
	@Override
	public Map<String, String> getSupportedCapabilities() {
		Map<String, String> discoveredCapabilities = new HashMap<String, String>();
		return discoveredCapabilities;
	}

	/**{@inheritDoc}*/
	@Override
	public Class<? extends Plugin<? extends PluginDeclaration>> getPluginImplementation() {
		return AccountingDashboardHarvesterPlugin.class;
	}
	
	@Override
	public String toString(){
		return String.format("{"
					+ "name:%s,"
					+ "version:%s,"
					+ "description:%s,"
					+ "pluginImplementation:%s,"
				+ "}",
				getName(), 
				getVersion(), 
				getDescription(),
				getPluginImplementation().getClass().getSimpleName());
	}

}
