/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.ServerFeatures;
import com.couchbase.client.core.endpoint.ServerFeaturesEvent;
import com.couchbase.client.core.endpoint.kv.ErrorMap;
import com.couchbase.client.core.endpoint.kv.KeyValueStatus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.KeepAlive;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.ResponseStatusDetails;
import com.couchbase.client.core.message.kv.AbstractKeyValueRequest;
import com.couchbase.client.core.message.kv.AbstractKeyValueResponse;
import com.couchbase.client.core.message.kv.AppendRequest;
import com.couchbase.client.core.message.kv.AppendResponse;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.BinaryResponse;
import com.couchbase.client.core.message.kv.BinaryStoreRequest;
import com.couchbase.client.core.message.kv.CounterRequest;
import com.couchbase.client.core.message.kv.CounterResponse;
import com.couchbase.client.core.message.kv.FailoverObserveSeqnoResponse;
import com.couchbase.client.core.message.kv.GetAllMutationTokensRequest;
import com.couchbase.client.core.message.kv.GetAllMutationTokensResponse;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.InsertRequest;
import com.couchbase.client.core.message.kv.InsertResponse;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.message.kv.NoFailoverObserveSeqnoResponse;
import com.couchbase.client.core.message.kv.NoopRequest;
import com.couchbase.client.core.message.kv.NoopResponse;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveResponse;
import com.couchbase.client.core.message.kv.ObserveSeqnoRequest;
import com.couchbase.client.core.message.kv.PrependRequest;
import com.couchbase.client.core.message.kv.PrependResponse;
import com.couchbase.client.core.message.kv.RemoveRequest;
import com.couchbase.client.core.message.kv.RemoveResponse;
import com.couchbase.client.core.message.kv.ReplaceRequest;
import com.couchbase.client.core.message.kv.ReplaceResponse;
import com.couchbase.client.core.message.kv.ReplicaGetRequest;
import com.couchbase.client.core.message.kv.StatRequest;
import com.couchbase.client.core.message.kv.StatResponse;
import com.couchbase.client.core.message.kv.TouchRequest;
import com.couchbase.client.core.message.kv.TouchResponse;
import com.couchbase.client.core.message.kv.UnlockRequest;
import com.couchbase.client.core.message.kv.UnlockResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMultiLookupRequest;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMultiMutationRequest;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMutationRequest;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocRequest;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.core.message.kv.subdoc.multi.LookupCommand;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiLookupResponse;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiMutationResponse;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiResult;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.core.message.kv.subdoc.multi.MutationCommand;
import com.couchbase.client.core.message.kv.subdoc.simple.AbstractSubdocRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SimpleSubdocResponse;
import com.couchbase.client.core.message.kv.subdoc.simple.SubExistRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubGetCountRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubGetRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import com.couchbase.client.deps.com.lmax.disruptor.EventSink;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.util.IllegalReferenceCountException;
import com.couchbase.client.deps.org.iq80.snappy.Snappy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class KeyValueHandler
extends AbstractGenericHandler<FullBinaryMemcacheResponse, BinaryMemcacheRequest, BinaryRequest> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueHandler.class);
    public static final byte OP_GET_BUCKET_CONFIG = -75;
    public static final byte OP_GET = 0;
    public static final byte OP_GET_AND_LOCK = -108;
    public static final byte OP_GET_AND_TOUCH = 29;
    public static final byte OP_GET_REPLICA = -125;
    public static final byte OP_INSERT = 2;
    public static final byte OP_UPSERT = 1;
    public static final byte OP_REPLACE = 3;
    public static final byte OP_REMOVE = 4;
    public static final byte OP_COUNTER_INCR = 5;
    public static final byte OP_COUNTER_DECR = 6;
    public static final byte OP_UNLOCK = -107;
    public static final byte OP_OBSERVE = -110;
    public static final byte OP_OBSERVE_SEQ = -111;
    public static final byte OP_TOUCH = 28;
    public static final byte OP_APPEND = 14;
    public static final byte OP_PREPEND = 15;
    public static final byte OP_NOOP = 10;
    public static final byte OP_STAT = 16;
    public static final byte OP_GET_ALL_MUTATION_TOKENS = 72;
    public static final byte OP_SUB_GET = -59;
    public static final byte OP_SUB_EXIST = -58;
    public static final byte OP_SUB_DICT_ADD = -57;
    public static final byte OP_SUB_DICT_UPSERT = -56;
    public static final byte OP_SUB_DELETE = -55;
    public static final byte OP_SUB_REPLACE = -54;
    public static final byte OP_SUB_ARRAY_PUSH_LAST = -53;
    public static final byte OP_SUB_ARRAY_PUSH_FIRST = -52;
    public static final byte OP_SUB_ARRAY_INSERT = -51;
    public static final byte OP_SUB_ARRAY_ADD_UNIQUE = -50;
    public static final byte OP_SUB_COUNTER = -49;
    public static final byte OP_SUB_MULTI_LOOKUP = -48;
    public static final byte OP_SUB_MULTI_MUTATION = -47;
    public static final byte OP_SUB_GET_COUNT = -46;
    public static final byte FRAMING_EXTRAS_TRACING = 0;
    public static final byte SUBDOC_BITMASK_MKDIR_P = 1;
    public static final byte SUBDOC_FLAG_XATTR_PATH = 4;
    public static final byte SUBDOC_FLAG_EXPAND_MACROS = 16;
    public static final byte SUBDOC_DOCFLAG_MKDOC = 1;
    public static final byte SUBDOC_DOCFLAG_INSERT = 2;
    public static final byte SUBDOC_DOCFLAG_ACCESS_DELETED = 4;
    public static final byte DATATYPE_SNAPPY = 2;
    boolean seqOnMutation = false;
    boolean snappyEnabled = false;
    final int minCompressionSize;
    final double minCompressionRatio;

    public KeyValueHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, isTransient, pipeline);
        this.minCompressionRatio = endpoint.environment().compressionMinRatio();
        this.minCompressionSize = endpoint.environment().compressionMinSize();
    }

    KeyValueHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, Queue<BinaryRequest> queue, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, queue, isTransient, pipeline);
        this.minCompressionRatio = endpoint.environment().compressionMinRatio();
        this.minCompressionSize = endpoint.environment().compressionMinSize();
    }

    @Override
    protected BinaryMemcacheRequest encodeRequest(ChannelHandlerContext ctx, BinaryRequest msg) throws Exception {
        BinaryMemcacheRequest request = this.encodeCommonRequest(ctx, msg);
        if (request == null) {
            request = this.encodeOtherRequest(ctx, msg);
        }
        if (msg.partition() >= 0) {
            request.setReserved(msg.partition());
        }
        request.setOpaque(msg.opaque());
        try {
            if (!(msg instanceof ObserveRequest) && !(msg instanceof ObserveSeqnoRequest) && request instanceof FullBinaryMemcacheRequest) {
                ((FullBinaryMemcacheRequest)request).content().retain();
            }
        }
        catch (IllegalReferenceCountException ex) {
            if (request.getExtras() != null && request.getExtras().refCnt() > 0) {
                try {
                    request.getExtras().release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ex;
        }
        if (this.snappyEnabled && this.isEligibleForCompression(msg)) {
            this.handleSnappyCompression(ctx, request);
        }
        return request;
    }

    private boolean isEligibleForCompression(BinaryRequest msg) {
        return msg instanceof BinaryStoreRequest || msg instanceof AppendRequest || msg instanceof PrependRequest;
    }

    private void handleSnappyCompression(ChannelHandlerContext ctx, BinaryMemcacheRequest r) {
        ByteBuf compressedContent;
        if (!(r instanceof FullBinaryMemcacheRequest)) {
            return;
        }
        FullBinaryMemcacheRequest request = (FullBinaryMemcacheRequest)r;
        int uncompressedLength = request.content().readableBytes();
        if (uncompressedLength < this.minCompressionSize || uncompressedLength == 0) {
            return;
        }
        try {
            compressedContent = this.tryCompress(request.content());
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not snappy-compress value.", ex);
        }
        if (compressedContent != null) {
            request.setDataType((byte)(request.getDataType() | 2));
            request.setContent(compressedContent);
            request.setTotalBodyLength(request.getExtrasLength() + request.getKeyLength() + compressedContent.readableBytes());
        }
    }

    private ByteBuf tryCompress(ByteBuf buf) {
        int compressedLength;
        int uncompressedLength = buf.readableBytes();
        byte[] compressed = new byte[Snappy.maxCompressedLength(uncompressedLength)];
        if (buf.hasArray()) {
            compressedLength = Snappy.compress(buf.array(), buf.arrayOffset() + buf.readerIndex(), uncompressedLength, compressed, 0);
        } else {
            byte[] data = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), data);
            compressedLength = Snappy.compress(data, 0, data.length, compressed, 0);
        }
        double ratio = (double)compressedLength / (double)uncompressedLength;
        if (ratio > this.minCompressionRatio) {
            return null;
        }
        byte[] trimmedCompressed = Arrays.copyOf(compressed, compressedLength);
        return Unpooled.wrappedBuffer(trimmedCompressed);
    }

    private void handleSnappyDecompression(ChannelHandlerContext ctx, FullBinaryMemcacheResponse response) {
        ByteBuf decompressed;
        if (response.content().readableBytes() > 0) {
            byte[] compressed = Unpooled.copiedBuffer(response.content()).array();
            try {
                decompressed = Unpooled.wrappedBuffer(Snappy.uncompress(compressed, 0, compressed.length));
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not decode snappy-compressed value.", ex);
            }
        } else {
            decompressed = Unpooled.buffer(0);
        }
        response.content().release();
        response.setContent(decompressed);
        response.setTotalBodyLength(response.getExtrasLength() + response.getKeyLength() + decompressed.readableBytes());
        response.setDataType((byte)(response.getDataType() & 0xFFFFFFFD));
    }

    private BinaryMemcacheRequest encodeCommonRequest(ChannelHandlerContext ctx, BinaryRequest msg) {
        if (msg instanceof GetRequest) {
            return KeyValueHandler.handleGetRequest(ctx, (GetRequest)msg);
        }
        if (msg instanceof BinaryStoreRequest) {
            return KeyValueHandler.handleStoreRequest(ctx, (BinaryStoreRequest)msg);
        }
        if (msg instanceof ReplicaGetRequest) {
            return KeyValueHandler.handleReplicaGetRequest((ReplicaGetRequest)msg);
        }
        if (msg instanceof RemoveRequest) {
            return KeyValueHandler.handleRemoveRequest((RemoveRequest)msg);
        }
        if (msg instanceof CounterRequest) {
            return KeyValueHandler.handleCounterRequest(ctx, (CounterRequest)msg);
        }
        if (msg instanceof TouchRequest) {
            return KeyValueHandler.handleTouchRequest(ctx, (TouchRequest)msg);
        }
        if (msg instanceof UnlockRequest) {
            return KeyValueHandler.handleUnlockRequest((UnlockRequest)msg);
        }
        return null;
    }

    private BinaryMemcacheRequest encodeOtherRequest(ChannelHandlerContext ctx, BinaryRequest msg) {
        if (msg instanceof ObserveRequest) {
            return KeyValueHandler.handleObserveRequest(ctx, (ObserveRequest)msg);
        }
        if (msg instanceof ObserveSeqnoRequest) {
            return KeyValueHandler.handleObserveSeqnoRequest(ctx, (ObserveSeqnoRequest)msg);
        }
        if (msg instanceof GetBucketConfigRequest) {
            return KeyValueHandler.handleGetBucketConfigRequest();
        }
        if (msg instanceof AppendRequest) {
            return KeyValueHandler.handleAppendRequest((AppendRequest)msg);
        }
        if (msg instanceof PrependRequest) {
            return KeyValueHandler.handlePrependRequest((PrependRequest)msg);
        }
        if (msg instanceof KeepAliveRequest) {
            return KeyValueHandler.handleKeepAliveRequest((KeepAliveRequest)msg);
        }
        if (msg instanceof StatRequest) {
            return KeyValueHandler.handleStatRequest((StatRequest)msg);
        }
        if (msg instanceof GetAllMutationTokensRequest) {
            return KeyValueHandler.handleGetAllMutationTokensRequest(ctx, (GetAllMutationTokensRequest)msg);
        }
        if (msg instanceof BinarySubdocRequest) {
            return KeyValueHandler.handleSubdocumentRequest(ctx, (BinarySubdocRequest)msg);
        }
        if (msg instanceof BinarySubdocMultiLookupRequest) {
            return KeyValueHandler.handleSubdocumentMultiLookupRequest(ctx, (BinarySubdocMultiLookupRequest)msg);
        }
        if (msg instanceof BinarySubdocMultiMutationRequest) {
            return KeyValueHandler.handleSubdocumentMultiMutationRequest(ctx, (BinarySubdocMultiMutationRequest)msg);
        }
        if (msg instanceof NoopRequest) {
            return KeyValueHandler.handleNoopRequest(ctx, (NoopRequest)msg);
        }
        throw new IllegalArgumentException("Unknown incoming BinaryRequest type " + msg.getClass());
    }

    private static BinaryMemcacheRequest handleNoopRequest(ChannelHandlerContext ctx, NoopRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)10);
        return request;
    }

    private static BinaryMemcacheRequest handleGetRequest(ChannelHandlerContext ctx, GetRequest msg) {
        ByteBuf extras;
        byte opcode;
        if (msg.lock()) {
            opcode = -108;
            extras = ctx.alloc().buffer().writeInt(msg.expiry());
        } else if (msg.touch()) {
            opcode = 29;
            extras = ctx.alloc().buffer().writeInt(msg.expiry());
        } else {
            opcode = 0;
            extras = Unpooled.EMPTY_BUFFER;
        }
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode(opcode).setKeyLength(keyLength).setExtras(extras).setExtrasLength(extrasLength).setTotalBodyLength(keyLength + extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleGetBucketConfigRequest() {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)-75);
        return request;
    }

    private static BinaryMemcacheRequest handleReplicaGetRequest(ReplicaGetRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)-125).setKeyLength(keyLength).setTotalBodyLength(keyLength);
        return request;
    }

    private static BinaryMemcacheRequest handleStoreRequest(ChannelHandlerContext ctx, BinaryStoreRequest msg) {
        ByteBuf extras = ctx.alloc().buffer(8);
        extras.writeInt(msg.flags());
        extras.writeInt(msg.expiration());
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, extras, msg.content());
        if (msg instanceof InsertRequest) {
            request.setOpcode((byte)2);
        } else if (msg instanceof UpsertRequest) {
            request.setOpcode((byte)1);
        } else if (msg instanceof ReplaceRequest) {
            request.setOpcode((byte)3);
            request.setCAS(((ReplaceRequest)msg).cas());
        } else {
            throw new IllegalArgumentException("Unknown incoming BinaryStoreRequest type " + msg.getClass());
        }
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + msg.content().readableBytes() + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleRemoveRequest(RemoveRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)4);
        request.setCAS(msg.cas());
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength);
        return request;
    }

    private static BinaryMemcacheRequest handleCounterRequest(ChannelHandlerContext ctx, CounterRequest msg) {
        ByteBuf extras = ctx.alloc().buffer();
        extras.writeLong(Math.abs(msg.delta()));
        extras.writeLong(msg.initial());
        extras.writeInt(msg.expiry());
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key, extras);
        request.setOpcode(msg.delta() < 0L ? (byte)6 : 5);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleUnlockRequest(UnlockRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)-107);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength);
        request.setCAS(msg.cas());
        return request;
    }

    private static BinaryMemcacheRequest handleTouchRequest(ChannelHandlerContext ctx, TouchRequest msg) {
        ByteBuf extras = ctx.alloc().buffer();
        extras.writeInt(msg.expiry());
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setExtras(extras);
        request.setOpcode((byte)28);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + extrasLength);
        request.setExtrasLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleObserveRequest(ChannelHandlerContext ctx, ObserveRequest msg) {
        String key = msg.key();
        short keyLength = (short)msg.keyBytes().length;
        ByteBuf content = ctx.alloc().buffer();
        content.writeShort(msg.partition());
        content.writeShort(keyLength);
        content.writeBytes(key.getBytes(CHARSET));
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(EMPTY_BYTES, Unpooled.EMPTY_BUFFER, content);
        request.setOpcode((byte)-110);
        request.setTotalBodyLength(content.readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleObserveSeqnoRequest(ChannelHandlerContext ctx, ObserveSeqnoRequest msg) {
        ByteBuf content = ctx.alloc().buffer();
        content.writeLong(msg.vbucketUUID());
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(EMPTY_BYTES, Unpooled.EMPTY_BUFFER, content);
        request.setOpcode((byte)-111);
        request.setTotalBodyLength(content.readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleAppendRequest(AppendRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, msg.content());
        request.setOpcode((byte)14);
        request.setKeyLength(keyLength);
        request.setCAS(msg.cas());
        request.setTotalBodyLength(keyLength + msg.content().readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handlePrependRequest(PrependRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, msg.content());
        request.setOpcode((byte)15);
        request.setKeyLength(keyLength);
        request.setCAS(msg.cas());
        request.setTotalBodyLength(keyLength + msg.content().readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleKeepAliveRequest(KeepAliveRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)10).setKeyLength((short)0).setExtras(Unpooled.EMPTY_BUFFER).setExtrasLength((byte)0).setTotalBodyLength(0);
        return request;
    }

    private static BinaryMemcacheRequest handleStatRequest(StatRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        request.setOpcode((byte)16).setKeyLength(keyLength).setTotalBodyLength(keyLength);
        return request;
    }

    private static BinaryMemcacheRequest handleGetAllMutationTokensRequest(ChannelHandlerContext ctx, GetAllMutationTokensRequest msg) {
        ByteBuf extras;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(EMPTY_BYTES);
        switch (msg.partitionState()) {
            case ANY: {
                extras = Unpooled.EMPTY_BUFFER;
                break;
            }
            default: {
                extras = ctx.alloc().buffer().writeInt(msg.partitionState().value());
            }
        }
        byte extrasLength = (byte)extras.readableBytes();
        request.setOpcode((byte)72).setExtras(extras).setExtrasLength(extrasLength).setTotalBodyLength(extrasLength);
        return request;
    }

    private static BinaryMemcacheRequest handleSubdocumentRequest(ChannelHandlerContext ctx, BinarySubdocRequest msg) {
        AbstractSubdocRequest req;
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        ByteBuf extras = ctx.alloc().buffer(3, 8);
        byte extrasLength = 3;
        extras.writeShort(msg.pathLength());
        long cas = 0L;
        if (msg instanceof BinarySubdocMutationRequest) {
            BinarySubdocMutationRequest mut = (BinarySubdocMutationRequest)msg;
            byte flags = 0;
            if (mut.createIntermediaryPath()) {
                flags = (byte)(flags | 1);
            }
            if (mut.xattr()) {
                flags = (byte)(flags | 4);
            }
            if (mut.expandMacros()) {
                flags = (byte)(flags | 0x10);
            }
            extras.writeByte(flags);
            if ((long)mut.expiration() != 0L) {
                extrasLength = 7;
                extras.writeInt(mut.expiration());
            }
            byte docFlags = 0;
            if (mut.upsertDocument()) {
                docFlags = (byte)(docFlags | 1);
            }
            if (mut.insertDocument()) {
                docFlags = (byte)(docFlags | 2);
            }
            if (docFlags != 0) {
                extrasLength = (byte)(extrasLength + 1);
                extras.writeByte(docFlags);
            }
            cas = mut.cas();
        } else if (msg instanceof SubGetRequest) {
            req = (SubGetRequest)msg;
            if (((SubGetRequest)req).xattr()) {
                extras.writeByte(4);
            } else {
                extras.writeByte(0);
            }
            if (((SubGetRequest)req).accessDeleted()) {
                extrasLength = (byte)(extrasLength + 1);
                extras.writeByte(4);
            }
        } else if (msg instanceof SubExistRequest) {
            req = (SubExistRequest)msg;
            if (((SubExistRequest)req).xattr()) {
                extras.writeByte(4);
            } else {
                extras.writeByte(0);
            }
            if (((SubExistRequest)req).accessDeleted()) {
                extrasLength = (byte)(extrasLength + 1);
                extras.writeByte(4);
            }
        } else if (msg instanceof SubGetCountRequest) {
            req = (SubGetCountRequest)msg;
            if (((SubGetCountRequest)req).xattr()) {
                extras.writeByte(4);
            } else {
                extras.writeByte(0);
            }
            if (((SubGetCountRequest)req).accessDeleted()) {
                extrasLength = (byte)(extrasLength + 1);
                extras.writeByte(4);
            }
        } else {
            extras.writeByte(0);
        }
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, extras, msg.content());
        request.setOpcode(msg.opcode()).setKeyLength(keyLength).setExtrasLength(extrasLength).setTotalBodyLength(keyLength + msg.content().readableBytes() + extrasLength).setCAS(cas);
        return request;
    }

    private static BinaryMemcacheRequest handleSubdocumentMultiLookupRequest(ChannelHandlerContext ctx, BinarySubdocMultiLookupRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        byte extrasLength = 0;
        ByteBuf extras = Unpooled.EMPTY_BUFFER;
        if (msg.docFlags() != 0) {
            extrasLength = 1;
            extras = ctx.alloc().buffer(extrasLength, extrasLength);
            extras.writeByte(msg.docFlags());
        }
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, extras, msg.content());
        request.setOpcode((byte)-48).setKeyLength(keyLength).setExtrasLength(extrasLength).setTotalBodyLength(keyLength + extrasLength + msg.content().readableBytes());
        return request;
    }

    private static BinaryMemcacheRequest handleSubdocumentMultiMutationRequest(ChannelHandlerContext ctx, BinarySubdocMultiMutationRequest msg) {
        byte[] key = msg.keyBytes();
        short keyLength = (short)key.length;
        byte extrasLength = 0;
        ByteBuf extras = Unpooled.EMPTY_BUFFER;
        if ((long)msg.expiration() != 0L) {
            extrasLength = 4;
        }
        if (msg.docFlags() != 0) {
            extrasLength = (byte)(extrasLength + 1);
        }
        if (extrasLength > 0) {
            extras = ctx.alloc().buffer(extrasLength, extrasLength);
            if ((long)msg.expiration() != 0L) {
                extras.writeInt(msg.expiration());
            }
            if (msg.docFlags() != 0) {
                extras.writeByte(msg.docFlags());
            }
        }
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, extras, msg.content());
        request.setOpcode((byte)-47).setCAS(msg.cas()).setKeyLength(keyLength).setExtrasLength(extrasLength).setTotalBodyLength(keyLength + msg.content().readableBytes() + extrasLength);
        return request;
    }

    private static boolean hasCompressionDatatype(byte datatype) {
        return (datatype & 2) == 2;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        ErrorMap.ErrorCode errorCode;
        BinaryRequest request = (BinaryRequest)this.currentRequest();
        if (request.opaque() != msg.getOpaque()) {
            throw new IllegalStateException("Opaque values for " + msg.getClass() + " do not match.");
        }
        ResponseStatus status = ResponseStatusConverter.fromBinary(msg.getStatus());
        ResponseStatusDetails statusDetails = ResponseStatusConverter.detailsFromBinary(msg.getDataType(), msg.content());
        if (KeyValueHandler.hasCompressionDatatype(msg.getDataType())) {
            if (!this.snappyEnabled) {
                LOGGER.debug("Snappy DataType bit set, but snappy has not been negotiated! Trying to decompress nonetheless!", (Object)msg);
            }
            this.handleSnappyDecompression(ctx, msg);
        }
        ErrorMap.ErrorCode errorCode2 = errorCode = status == ResponseStatus.FAILURE ? ResponseStatusConverter.readErrorCodeFromErrorMap(msg.getStatus()) : null;
        if (errorCode != null) {
            LOGGER.debug("ResponseStatus with Extended Error Code {}", (Object)errorCode.toString());
            if (errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.FETCH_CONFIG)) {
                LOGGER.debug(KeyValueHandler.logIdent(ctx, this.endpoint()) + "Config reload requested by the server, sending config reload message");
                this.endpoint().signalConfigReload();
            }
            if (errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.CONN_STATE_INVALIDATED)) {
                LOGGER.debug(KeyValueHandler.logIdent(ctx, this.endpoint()) + "Connection state has been invalidated by the server, reconnecting");
                ctx.close();
                status = ResponseStatus.FAILURE;
            }
            if (errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.TEMP)) {
                LOGGER.debug(KeyValueHandler.logIdent(ctx, this.endpoint()) + "Temporary failure using error code translation");
                status = ResponseStatus.TEMPORARY_FAILURE;
            }
            if (errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.AUTH)) {
                LOGGER.debug(KeyValueHandler.logIdent(ctx, this.endpoint()) + "Authentication failure using error code translation");
                status = ResponseStatus.ACCESS_ERROR;
            }
            if (errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.ITEM_LOCKED)) {
                errorCode.attributes().remove((Object)ErrorMap.ErrorAttribute.RETRY_NOW);
                errorCode.attributes().remove((Object)ErrorMap.ErrorAttribute.RETRY_LATER);
                errorCode.attributes().remove((Object)ErrorMap.ErrorAttribute.AUTO_RETRY);
                status = ResponseStatus.LOCKED;
            }
            if (errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.AUTO_RETRY) || errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.RETRY_NOW) || errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.RETRY_LATER)) {
                LOGGER.debug(KeyValueHandler.logIdent(ctx, this.endpoint()) + "Retry requested by the server");
                status = ResponseStatus.RETRY;
            }
            if (errorCode.attributes().contains((Object)ErrorMap.ErrorAttribute.AUTO_RETRY) && request.retryDelay() == null) {
                if (errorCode.retrySpec().strategy() == ErrorMap.RetryStrategy.CONSTANT) {
                    request.retryDelay(Delay.fixed(errorCode.retrySpec().interval(), TimeUnit.MILLISECONDS));
                } else if (errorCode.retrySpec().strategy() == ErrorMap.RetryStrategy.LINEAR) {
                    request.retryDelay(Delay.linear(TimeUnit.MILLISECONDS, errorCode.retrySpec().ceil(), 0L, errorCode.retrySpec().interval()));
                } else if (errorCode.retrySpec().strategy() == ErrorMap.RetryStrategy.EXPONENTIAL) {
                    request.retryDelay(Delay.exponential(TimeUnit.MILLISECONDS, errorCode.retrySpec().ceil(), 0L, errorCode.retrySpec().interval()));
                }
                request.retryAfter(errorCode.retrySpec().after());
                request.maxRetryDuration(System.currentTimeMillis() + errorCode.retrySpec().maxDuration());
            }
        }
        if (status.equals((Object)ResponseStatus.RETRY)) {
            KeyValueHandler.resetContentReaderIndex(request);
        } else {
            KeyValueHandler.maybeFreeContent(request);
        }
        msg.content().retain();
        CouchbaseResponse response = KeyValueHandler.handleCommonResponseMessages(request, msg, status, this.seqOnMutation);
        if (response == null) {
            response = KeyValueHandler.handleSubdocumentResponseMessages(request, msg, ctx, status, this.seqOnMutation);
        }
        if (response == null) {
            response = KeyValueHandler.handleSubdocumentMultiLookupResponseMessages(request, msg, ctx, status);
        }
        if (response == null) {
            response = KeyValueHandler.handleSubdocumentMultiMutationResponseMessages(request, msg, ctx, status, this.seqOnMutation);
        }
        if (response == null) {
            response = KeyValueHandler.handleOtherResponseMessages(request, msg, status, this.seqOnMutation, this.remoteHostname());
        }
        if (response == null) {
            throw new IllegalStateException("Unhandled request/response pair: " + request.getClass() + "/" + msg.getClass());
        }
        if (request instanceof StatRequest) {
            ((StatRequest)request).add((StatResponse)response);
            if (((StatResponse)response).key() == null) {
                this.finishedDecoding();
            }
            return null;
        }
        this.finishedDecoding();
        if (statusDetails != null) {
            response.statusDetails(statusDetails);
        }
        if (msg.getFramingExtrasLength() > 0) {
            long duration = KeyValueHandler.parseServerDurationFromFrame(msg.getFramingExtras());
            ((BinaryResponse)response).serverDuration(duration);
            if (this.env().operationTracingEnabled() && this.currentDispatchSpan() != null) {
                this.currentDispatchSpan().setTag("peer.latency", duration + "us");
                if (this.currentDispatchSpan() instanceof ThresholdLogSpan) {
                    this.currentDispatchSpan().setBaggageItem("server_us", Long.toString(duration));
                }
            }
        }
        return response;
    }

    static long parseServerDurationFromFrame(ByteBuf frame) {
        while (frame.readableBytes() > 0) {
            byte control = frame.readByte();
            byte id = (byte)(control & 0xF0);
            byte len = (byte)(control & 0xF);
            if (id == 0) {
                return Math.round(Math.pow(frame.readUnsignedShort(), 1.74) / 2.0);
            }
            frame.skipBytes(len);
        }
        return 0L;
    }

    private static CouchbaseResponse handleCommonResponseMessages(BinaryRequest request, FullBinaryMemcacheResponse msg, ResponseStatus status, boolean seqOnMutation) {
        AbstractKeyValueResponse response = null;
        ByteBuf content = msg.content();
        long cas = msg.getCAS();
        short statusCode = msg.getStatus();
        String bucket = request.bucket();
        if (request instanceof GetRequest || request instanceof ReplicaGetRequest) {
            int flags = msg.getExtrasLength() > 0 ? msg.getExtras().getInt(0) : 0;
            response = new GetResponse(status, statusCode, cas, flags, bucket, content, request);
        } else if (request instanceof GetBucketConfigRequest) {
            response = new GetBucketConfigResponse(status, statusCode, bucket, content, ((GetBucketConfigRequest)request).hostname());
        } else if (request instanceof InsertRequest) {
            MutationToken descr = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new InsertResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof UpsertRequest) {
            MutationToken descr = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new UpsertResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof ReplaceRequest) {
            MutationToken descr = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new ReplaceResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof RemoveRequest) {
            MutationToken descr = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new RemoveResponse(status, statusCode, cas, bucket, content, descr, request);
        }
        return response;
    }

    private static CouchbaseResponse handleSubdocumentResponseMessages(BinaryRequest request, FullBinaryMemcacheResponse msg, ChannelHandlerContext ctx, ResponseStatus status, boolean seqOnMutation) {
        ByteBuf fragment;
        if (!(request instanceof BinarySubdocRequest)) {
            return null;
        }
        BinarySubdocRequest subdocRequest = (BinarySubdocRequest)request;
        long cas = msg.getCAS();
        short statusCode = msg.getStatus();
        String bucket = request.bucket();
        MutationToken mutationToken = null;
        if (msg.getExtrasLength() > 0) {
            mutationToken = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
        }
        if (msg.content() != null && msg.content().readableBytes() > 0) {
            fragment = msg.content();
        } else if (msg.content() != null) {
            msg.content().release();
            fragment = Unpooled.EMPTY_BUFFER;
        } else {
            fragment = Unpooled.EMPTY_BUFFER;
        }
        return new SimpleSubdocResponse(status, statusCode, bucket, fragment, subdocRequest, cas, mutationToken);
    }

    private static CouchbaseResponse handleSubdocumentMultiLookupResponseMessages(BinaryRequest request, FullBinaryMemcacheResponse msg, ChannelHandlerContext ctx, ResponseStatus status) {
        List<MultiResult<Lookup>> responses;
        if (!(request instanceof BinarySubdocMultiLookupRequest)) {
            return null;
        }
        BinarySubdocMultiLookupRequest subdocRequest = (BinarySubdocMultiLookupRequest)request;
        short statusCode = msg.getStatus();
        long cas = msg.getCAS();
        String bucket = request.bucket();
        ByteBuf body = msg.content();
        if (status.isSuccess() || ResponseStatus.SUBDOC_MULTI_PATH_FAILURE.equals((Object)status)) {
            long bodyLength = body.readableBytes();
            List<LookupCommand> commands = subdocRequest.commands();
            responses = new ArrayList(commands.size());
            for (LookupCommand cmd : commands) {
                if (msg.content().readableBytes() < 6) {
                    body.release();
                    throw new IllegalStateException("Expected " + commands.size() + " lookup responses, only got " + responses.size() + ", total of " + bodyLength + " bytes");
                }
                short cmdStatus = body.readShort();
                int valueLength = body.readInt();
                ByteBuf value = ctx.alloc().buffer(valueLength, valueLength);
                value.writeBytes(body, valueLength);
                responses.add(MultiResult.create(cmdStatus, ResponseStatusConverter.fromBinary(cmdStatus), cmd.path(), cmd.lookup(), value));
            }
        } else {
            responses = Collections.emptyList();
        }
        body.release();
        return new MultiLookupResponse(status, statusCode, bucket, responses, subdocRequest, cas);
    }

    private static CouchbaseResponse handleSubdocumentMultiMutationResponseMessages(BinaryRequest request, FullBinaryMemcacheResponse msg, ChannelHandlerContext ctx, ResponseStatus status, boolean seqOnMutation) {
        MultiMutationResponse response;
        if (!(request instanceof BinarySubdocMultiMutationRequest)) {
            return null;
        }
        BinarySubdocMultiMutationRequest subdocRequest = (BinarySubdocMultiMutationRequest)request;
        long cas = msg.getCAS();
        short statusCode = msg.getStatus();
        String bucket = request.bucket();
        MutationToken mutationToken = null;
        if (msg.getExtrasLength() > 0) {
            mutationToken = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
        }
        ByteBuf body = msg.content();
        if (status.isSuccess()) {
            List<MutationCommand> commands = subdocRequest.commands();
            ArrayList<MultiResult<Mutation>> responses = new ArrayList<MultiResult<Mutation>>(commands.size());
            ListIterator<MutationCommand> it = commands.listIterator();
            int explicitResultSize = 0;
            while (msg.content().readableBytes() >= 7) {
                ByteBuf responseValue;
                ++explicitResultSize;
                byte responseIndex = body.readByte();
                short responseStatus = body.readShort();
                int responseLength = body.readInt();
                if (responseLength > 0) {
                    responseValue = ctx.alloc().buffer(responseLength, responseLength);
                    responseValue.writeBytes(body, responseLength);
                } else {
                    responseValue = Unpooled.EMPTY_BUFFER;
                }
                if (it.nextIndex() > responseIndex) {
                    body.release();
                    throw new IllegalStateException("Unable to interpret multi mutation response, responseIndex = " + responseIndex + " while next available command was #" + it.nextIndex());
                }
                while (it.nextIndex() < responseIndex) {
                    MutationCommand noResultCommand = it.next();
                    responses.add(MultiResult.create(KeyValueStatus.SUCCESS.code(), ResponseStatus.SUCCESS, noResultCommand.path(), noResultCommand.mutation(), Unpooled.EMPTY_BUFFER));
                }
                MutationCommand cmd = it.next();
                responses.add(MultiResult.create(responseStatus, ResponseStatusConverter.fromBinary(responseStatus), cmd.path(), cmd.mutation(), responseValue));
            }
            while (it.hasNext()) {
                MutationCommand noResultCommand = it.next();
                responses.add(MultiResult.create(KeyValueStatus.SUCCESS.code(), ResponseStatus.SUCCESS, noResultCommand.path(), noResultCommand.mutation(), Unpooled.EMPTY_BUFFER));
            }
            if (responses.size() != commands.size()) {
                body.release();
                throw new IllegalStateException("Multi mutation spec size and result size differ: " + commands.size() + " vs " + responses.size() + ", including " + explicitResultSize + " explicit results");
            }
            response = new MultiMutationResponse(bucket, subdocRequest, cas, mutationToken, responses);
        } else if (ResponseStatus.SUBDOC_MULTI_PATH_FAILURE.equals((Object)status)) {
            byte firstErrorIndex = body.readByte();
            short firstErrorCode = body.readShort();
            response = new MultiMutationResponse(status, statusCode, bucket, firstErrorIndex, firstErrorCode, subdocRequest, cas, mutationToken);
        } else {
            response = new MultiMutationResponse(status, statusCode, bucket, subdocRequest, cas, mutationToken);
        }
        body.release();
        return response;
    }

    private static MutationToken extractToken(String bucket, boolean seqOnMutation, boolean success, ByteBuf extras, long vbid) {
        if (success && seqOnMutation) {
            return new MutationToken(vbid, extras.readLong(), extras.readLong(), bucket);
        }
        return null;
    }

    private static CouchbaseResponse handleOtherResponseMessages(BinaryRequest request, FullBinaryMemcacheResponse msg, ResponseStatus status, boolean seqOnMutation, String remoteHostname) {
        AbstractKeyValueResponse response = null;
        ByteBuf content = msg.content();
        long cas = msg.getCAS();
        short statusCode = msg.getStatus();
        String bucket = request.bucket();
        if (request instanceof UnlockRequest) {
            response = new UnlockResponse(status, statusCode, bucket, content, request);
        } else if (request instanceof TouchRequest) {
            response = new TouchResponse(status, statusCode, bucket, content, request);
        } else if (request instanceof AppendRequest) {
            MutationToken descr = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new AppendResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof PrependRequest) {
            MutationToken descr = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new PrependResponse(status, statusCode, cas, bucket, content, descr, request);
        } else if (request instanceof KeepAliveRequest) {
            KeyValueHandler.releaseContent(content);
            response = new KeepAliveResponse(status, statusCode, request);
        } else if (request instanceof NoopRequest) {
            KeyValueHandler.releaseContent(content);
            response = new NoopResponse(status, statusCode, request);
        } else if (request instanceof CounterRequest) {
            long value = status.isSuccess() ? content.readLong() : 0L;
            KeyValueHandler.releaseContent(content);
            MutationToken descr = KeyValueHandler.extractToken(bucket, seqOnMutation, status.isSuccess(), msg.getExtras(), request.partition());
            response = new CounterResponse(status, statusCode, bucket, value, cas, descr, request);
        } else if (request instanceof StatRequest) {
            String key = null;
            if (msg.getKey() != null) {
                key = new String(msg.getKey(), CHARSET);
            }
            String value = content.toString(CHARSET);
            KeyValueHandler.releaseContent(content);
            response = new StatResponse(status, statusCode, remoteHostname, key, value, bucket, request);
        } else if (request instanceof GetAllMutationTokensRequest) {
            MutationToken[] mutationTokens = new MutationToken[content.readableBytes() / 10];
            for (int i = 0; i < mutationTokens.length; ++i) {
                mutationTokens[i] = new MutationToken(content.readShort(), 0L, content.readLong(), request.bucket());
            }
            KeyValueHandler.releaseContent(content);
            response = new GetAllMutationTokensResponse(mutationTokens, status, statusCode, bucket, (CouchbaseRequest)request);
        } else if (request instanceof ObserveRequest) {
            byte observed = ObserveResponse.ObserveStatus.UNKNOWN.value();
            long observedCas = 0L;
            if (status.isSuccess()) {
                short keyLength = content.getShort(2);
                observed = content.getByte(keyLength + 4);
                observedCas = content.getLong(keyLength + 5);
            }
            KeyValueHandler.releaseContent(content);
            response = new ObserveResponse(status, statusCode, observed, ((ObserveRequest)request).master(), observedCas, bucket, request);
        } else if (request instanceof ObserveSeqnoRequest) {
            if (status.isSuccess()) {
                byte format = content.readByte();
                switch (format) {
                    case 0: {
                        response = new NoFailoverObserveSeqnoResponse(((ObserveSeqnoRequest)request).master(), content.readShort(), content.readLong(), content.readLong(), content.readLong(), status, statusCode, bucket, request);
                        break;
                    }
                    case 1: {
                        response = new FailoverObserveSeqnoResponse(((ObserveSeqnoRequest)request).master(), content.readShort(), content.readLong(), content.readLong(), content.readLong(), content.readLong(), content.readLong(), status, statusCode, bucket, request);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown format for observe-seq: " + format);
                    }
                }
            } else {
                response = new NoFailoverObserveSeqnoResponse(((ObserveSeqnoRequest)request).master(), 0, 0L, 0L, 0L, status, statusCode, bucket, request);
            }
            KeyValueHandler.releaseContent(content);
        }
        return response;
    }

    private static void maybeFreeContent(BinaryRequest request) {
        KeyValueHandler.releaseContent(KeyValueHandler.contentFromWriteRequest(request));
    }

    private static ByteBuf contentFromWriteRequest(BinaryRequest request) {
        ByteBuf content = null;
        if (request instanceof BinaryStoreRequest) {
            content = ((BinaryStoreRequest)request).content();
        } else if (request instanceof AppendRequest) {
            content = ((AppendRequest)request).content();
        } else if (request instanceof PrependRequest) {
            content = ((PrependRequest)request).content();
        } else if (request instanceof BinarySubdocRequest) {
            content = ((BinarySubdocRequest)request).content();
        } else if (request instanceof BinarySubdocMultiLookupRequest) {
            content = ((BinarySubdocMultiLookupRequest)request).content();
        } else if (request instanceof BinarySubdocMultiMutationRequest) {
            content = ((BinarySubdocMultiMutationRequest)request).content();
        }
        return content;
    }

    private static void resetContentReaderIndex(BinaryRequest request) {
        ByteBuf content = KeyValueHandler.contentFromWriteRequest(request);
        if (content != null) {
            try {
                content.readerIndex(0);
            }
            catch (Exception ex) {
                LOGGER.warn("Exception while resetting the content reader index to 0, please report this as a bug.", ex);
            }
        }
    }

    private static void releaseContent(ByteBuf content) {
        if (content != null && content.refCnt() > 0) {
            content.release();
        }
    }

    @Override
    protected void sideEffectRequestToCancel(BinaryRequest request) {
        super.sideEffectRequestToCancel(request);
        if (request instanceof BinaryStoreRequest) {
            ((BinaryStoreRequest)request).content().release();
        } else if (request instanceof AppendRequest) {
            ((AppendRequest)request).content().release();
        } else if (request instanceof PrependRequest) {
            ((PrependRequest)request).content().release();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ServerFeaturesEvent) {
            this.seqOnMutation = this.env().mutationTokensEnabled() && ((ServerFeaturesEvent)evt).supportedFeatures().contains((Object)ServerFeatures.MUTATION_SEQNO);
            this.snappyEnabled = ((ServerFeaturesEvent)evt).supportedFeatures().contains((Object)ServerFeatures.SNAPPY);
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.BINARY;
    }

    protected static class KeepAliveResponse
    extends AbstractKeyValueResponse {
        public KeepAliveResponse(ResponseStatus status, short serverStatusCode, CouchbaseRequest request) {
            super(status, serverStatusCode, null, null, request);
        }
    }

    protected static class KeepAliveRequest
    extends AbstractKeyValueRequest
    implements KeepAlive {
        protected KeepAliveRequest() {
            super(null, null);
            this.partition((short)0);
        }
    }
}

