/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategies;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.LifecycleState;
import java.util.List;
import java.util.Random;

public class RandomSelectionStrategy
implements SelectionStrategy {
    private static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final int MAX_TRIES = 100;

    @Override
    public Endpoint select(CouchbaseRequest request, List<Endpoint> endpoints) {
        if (endpoints.size() == 0) {
            return null;
        }
        for (int i = 0; i < 100; ++i) {
            int selected = RANDOM.get().nextInt(endpoints.size());
            Endpoint endpoint = endpoints.get(selected);
            if (!endpoint.isState(LifecycleState.CONNECTED) || !endpoint.isFree()) continue;
            return endpoint;
        }
        return null;
    }
}

